import React, {useState} from 'react';
import {
  Text,
  SafeAreaView,
  TouchableOpacity,
  FlatList,
  StyleSheet,
  Modal,
  View,
  Image,
  TextInput,
} from 'react-native';
import Header from '../../components/Header/Header';
import I18n from '../../helper/i18/i18n';
import R from '../../assets/R';
import ItemList from './item';

const DebtView = props => {
  const {onTabChange, dataListStatus, dataListDebtItem, activeTab} = props;
  const IconSearch = R.images.icSearch;
  const renderTabViewItem = ({item}) => {
    const isActive = activeTab === item.key;
    return (
      <TouchableOpacity
        style={[styles.tab_button, isActive && styles.tabButtonActive]}
        onPress={() => onTabChange(item.key)}>
        <Text
          style={[
            styles.tabButtonText,
            isActive && styles.tabButtonTextActive,
          ]}>
          {item.title_status}
        </Text>
      </TouchableOpacity>
    );
  };
  const renderItem = ({item}) => {
    return <ItemList item={item} onPayPress={props.onPayPress} />;
  };
  const filteredDebtItems = dataListDebtItem.filter(
    item => item.status === activeTab,
  );

  return (
    <View style={styles.container}>
      <Header isBack title={I18n.t('Debt')} />

      <View style={styles.tab_container}>
        <FlatList
          data={dataListStatus}
          renderItem={renderTabViewItem}
          keyExtractor={item => item.key}
          horizontal
          showsHorizontalScrollIndicator={false}
          contentContainerStyle={styles.tab_scroll_content}
        />
      </View>
      <View
        style={{
          marginHorizontal: 15,
          flexDirection: 'row',
          alignItems: 'center',
          borderWidth: 1,
          borderColor: R.colors.gray400,
          borderRadius: 50,
          padding: 0,
          height: 35,
          paddingHorizontal: 10,
          marginVertical: 10,
        }}>
        <IconSearch width={20} height={20} stroke={R.colors.gray400} />
        <View style={{flex: 1}}>
          <TextInput
            placeholder={'Tìm kiếm'}
            style={styles.input}
            placeholderTextColor={R.colors.gray400}
          />
        </View>
      </View>

      <Text style={styles.sub_text}>{props.timeDebt}</Text>

      <FlatList
        data={filteredDebtItems}
        renderItem={renderItem}
        showsVerticalScrollIndicator={false}
        keyExtractor={item => item.id.toString()}
      />
    </View>
  );
};

export default DebtView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  input: {
    height: 35,
    paddingHorizontal: 5,
    paddingVertical: 0,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    color: R.colors.gray400,
    fontSize: R.fontsize.fontsSize12,
  },
  tab_container: {
    marginHorizontal: 10,
    justifyContent: 'center',
    paddingVertical: 5,
  },
  tab_button: {
    marginHorizontal: 5,
    borderRadius: 15,
    width: 132,
    backgroundColor: R.colors.gray400,
    alignItems: 'center',
    justifyContent: 'center',
  },
  tabButtonActive: {
    backgroundColor: R.colors.blue500,
  },
  tabButtonText: {
    fontFamily: R.fonts.InterSemiBold,
    fontWeight: '600',
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.white,
  },
  tabButtonTextActive: {
    color: R.colors.white,
    fontWeight: '600',
    fontFamily: R.fonts.InterSemiBold,
    fontSize: R.fontsize.fontsSize12,
  },
  tab_scroll_content: {
    height: 30,
  },
  sub_text: {
    color: R.colors.black,
    marginLeft: 15,
    fontFamily: R.fonts.InterMedium,
    fontWeight: '600',
    fontSize: R.fontsize.fontsSize12,
  },
});
