import {StyleSheet, Dimensions} from 'react-native';
import R from '../../../assets/R';

// ==================== HẰNG SỐ ====================
const {width: screenWidth, height: screenHeight} = Dimensions.get('window');
const HOUR_HEIGHT = 80;
const DAY_COLUMN_WIDTH = (screenWidth - 70) / 3;

const styles = StyleSheet.create({
  // ==================== CONTAINER CHÍNH ====================
  // Container tổng thể của màn hình Filter 3 ngày
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },

  // ==================== MONTH PICKER SECTION ====================
  // Container chứa bộ chọn tháng
  monthPickerContainer: {
    backgroundColor: R.colors.white,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
    paddingVertical: 10,
  },
  
  // Nội dung cuộn ngang của bộ chọn tháng
  monthPickerContent: {
    paddingHorizontal: 15,
  },
  
  // Item tháng trong bộ chọn
  monthItem: {
    paddingHorizontal: 20,
    paddingVertical: 10,
    marginRight: 10,
    borderRadius: 20,
    backgroundColor: R.colors.gray220,
  },
  
  // Item tháng được chọn
  monthItemSelected: {
    backgroundColor: R.colors.black,
  },
  
  // Text của item tháng
  monthItemText: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
  },
  
  // Text của item tháng được chọn
  monthItemTextSelected: {
    color: R.colors.white,
    fontFamily: R.fonts.InterMedium,
  },

  // ==================== 3 DAYS HEADER SECTION ====================
  // Container chứa header 3 ngày
  daysHeaderContainer: {
    flexDirection: 'row',
    backgroundColor: R.colors.gray220,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
  },
  
  // Header cột thời gian (trống)
  timeColumnHeader: {
    width: 70,
  },
  
  // Cell header của mỗi ngày
  dayHeaderCell: {
    width: DAY_COLUMN_WIDTH,
    alignItems: 'center',
    justifyContent: 'center',
    borderRightWidth: 1,
    borderRightColor: R.colors.gray220,
  },
  
  // Text tên ngày (Thứ 2, Thứ 3...)
  dayHeaderText: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterMedium,
    color: R.colors.black,
    fontWeight: '600',
  },
  
  // Text tên ngày hôm nay
  todayHeaderText: {
    color: R.colors.black,
    fontFamily: R.fonts.InterMedium,
    fontWeight: '600',
  },
  
  // Container chứa số ngày
  dayNumberContainer: {
    minWidth: 28,
    minHeight: 28,
    borderRadius: 30,
    alignItems: 'center',
    justifyContent: 'center',
    marginVertical: 5,
  },
  
  // Container số ngày hôm nay (có background xanh)
  todayNumberContainer: {
    backgroundColor: R.colors.main,
  },
  
  // Text số ngày
  dayHeaderNumber: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    fontWeight: '400',
  },
  
  // Text số ngày hôm nay (màu trắng)
  todayHeaderNumber: {
    color: R.colors.white,
    fontFamily: R.fonts.InterMedium,
    fontWeight: '600',
  },

  // ==================== TIME SLOTS SECTION ====================
  // Container chứa các khung thời gian
  timeSlotsContainer: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  
  // Nội dung cuộn dọc
  scrollContent: {},
  
  // Container timeline tổng thể
  timelineContainer: {
    flexDirection: 'row',
    position: 'relative',
  },
  
  // Cột nhãn thời gian bên trái
  timeLabelsColumn: {
    width: 70,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray220,
  },
  
  // Container chứa grid 3 ngày
  daysGridContainer: {
    flex: 1,
    flexDirection: 'row',
  },
  
  // Cột của mỗi ngày
  dayColumn: {
    width: DAY_COLUMN_WIDTH,
    position: 'relative',
    borderRightWidth: 1,
    borderRightColor: R.colors.gray220,
  },
  
  // Khung thời gian (1 giờ)
  timeSlot: {
    height: HOUR_HEIGHT,
    alignItems: 'center',
    justifyContent: 'center',
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
  },
  
  // Cell grid của mỗi giờ trong ngày
  gridCell: {
    height: HOUR_HEIGHT,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
    width: '100%',
  },
  
  // Text hiển thị giờ (07:00, 08:00...)
  timeText: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    fontWeight: '400',
  },

  // ==================== EVENT CARD SECTION ====================
  // Card hiển thị sự kiện
  eventCard: {
    borderRadius: 8,
    paddingHorizontal: 6,
    paddingVertical: 4,
  },
  
  // Tiêu đề sự kiện
  eventTitle: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterMedium,
    color: R.colors.white,
    marginBottom: 2,
  },
  
  // Phụ đề sự kiện
  eventSubtitle: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.white,
    fontWeight: '400',
  },
  
  // Thời gian sự kiện
  eventTime: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.white,
    fontWeight: '400',
  },
});

export default styles;
