import { Image, StyleSheet, Text, View } from 'react-native'
import React from 'react'
import R from '../../../assets/R'
import Button from '../../../components/Button'
import { useNavigation } from "@react-navigation/native";
import { DETAILCERTIFICATE } from "../../../routers/ScreenNames";
const ItemNav = () => {
  const navigation = useNavigation();
  return (
    <View style={styles.container_card}>
        <View style={styles.header_card_item}>
          <Text style={styles.text_title_left}>Chứng chỉ toeic</Text>

          <Text
            onPress={() => navigation.navigate(DETAILCERTIFICATE)}
            style={styles.text_title_right}>Chi tiết</Text>
        </View>
        <View style={styles.image_container}>
          <Image
            source={R.images.igProfileDemo}
            style={styles.image}
          />
        </View>
        <View style={styles.footer_card_item}>
          <View>
            <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Trạng thái:{' '}
              <Text style={{ fontFamily: R.fonts.InterRegular }}>Đang đánh giá</Text>
              </Text>
            <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>
              Ngày đăng ký:{' '}
              <Text style={{ fontFamily: R.fonts.InterRegular }}>23/10/2024</Text>
              </Text>
            <Text style={[styles.sub_text, { color: R.colors.blue500 , fontFamily: R.fonts.InterMedium }]}>Không dùng để đăng ký học bổng</Text>
          </View>
          <View style={styles.button_container}>
            <Button
              title={"Huỷ"}
              fontFamily={R.fonts.InterRegular}
              fontWeight={300}
              fontSize={14}
              width={61}
              height={35}
              backgroundColor={R.colors.red}
              borderRadius={10}
              textColor={R.colors.white}
            />
          </View>

        </View>
    </View>
  )
}

export default ItemNav

const styles = StyleSheet.create({
  container_card: {
    borderRadius: 15,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    marginVertical: 5,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  button_container: {
    alignSelf: "flex-end",
  },
  header_card_item: {
    justifyContent: "space-between",
    flexDirection: "row",
  },
  footer_card_item: {
    justifyContent: "space-between",
    flexDirection: "row",
  },
  image: {
    maxWidth: '100%',
    maxHeight: 200,
    resizeMode: "contain",
  },
  image_container: {
    maxWidth: 340,
    maxHeight: 200,
    alignSelf: "center",
  },
  text_title_left: {
    fontFamily: R.fonts.InterMedium,
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '600',
    color: R.colors.black
  },
  text_title_right: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '400',
    textDecorationLine: 'underline',  
    color: R.colors.main
  },
  sub_text: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: "300",
    color: R.colors.black
  }
})