import React from "react";
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  Image,
  SafeAreaView,
  ScrollView,
} from "react-native";
import R from "../../../assets/R";
import Header from "../../../components/Header/Header";

const DetailCertificateView = (props) => {
  return (
    <View style={{flex:1,}}>
          <Header isBack={true} title={"Chứng chỉ toeic"} />
      <ScrollView showsVerticalScrollIndicator={false} style={styles.container}>
    

          <View style={styles.container_card}>
            <View style={styles.status}>
              <Text style={[styles.text_title, { color: R.colors.white }]}>
                Chứng chỉ đang được đánh giá
              </Text>
            </View>
            <View style={styles.card_item}>
              <View style={styles.header_card_item}>
                <Text style={[styles.text_title , { fontFamily: R.fonts.InterMedium } ]}>Chứng chỉ toeic</Text>


              </View>
              <View style={styles.image_container}>
                <Image
                  source={R.images.igProfileDemo}
                  style={styles.image}
                />
              </View>
              <View >
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Loại chứng chỉ:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>TOEIC</Text>
                  </Text>
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Ngày sinh:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>23/10/2004</Text>
                  </Text>
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>
                  CCCD/CMND đăng ký:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>00228956325</Text>
                </Text>
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Ngày thi:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>23/10/2024</Text>
                  </Text>
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Tổng điểm:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>875</Text>
                  </Text>
                <View
                  style={{
                    flexDirection: "row",
                    justifyContent: "space-between",
                  }}
                >
                  <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Điểm nói:{' '}
                    <Text style={{ fontFamily: R.fonts.InterRegular }}>0</Text>
                    </Text>
                  <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Điểm nghe:{' '}
                    <Text style={{ fontFamily: R.fonts.InterRegular }}>445</Text>
                    </Text>
                </View>
                <View
                  style={{
                    flexDirection: "row",
                    justifyContent: "space-between",
                  }}
                >
                  <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Điểm đọc:{' '}
                    <Text style={{ fontFamily: R.fonts.InterRegular }}>430</Text>
                    </Text>
                  <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Điểm viết:{' '}
                    <Text style={{ fontFamily: R.fonts.InterRegular }}>0</Text>
                    </Text>
                </View>
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Số TRF:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>085692265852</Text>
                  </Text>
                <Text style={[styles.sub_text , { fontFamily: R.fonts.InterMedium } ]}>Có hiệu lực đến:{' '}
                  <Text style={{ fontFamily: R.fonts.InterRegular }}>23/10/2026</Text>
                  </Text>
                <Text style={[styles.sub_text, { color: R.colors.main , fontFamily: R.fonts.InterMedium }]}>
                  Không dùng để đăng ký học bổng
                </Text>
              </View>
            </View>
          </View>
      </ScrollView>
    </View>
  );
};

export default DetailCertificateView;

const styles = StyleSheet.create({
  container: {
    backgroundColor:R.colors.white,
    paddingBottom: 10,
  },
  image: {
    maxWidth: '100%',
    maxHeight: 200,
    resizeMode: "contain",
  },
  image_container: {
    maxWidth: 340,
    maxHeight: 200,
    alignSelf: "center",
  },
  status: {
    backgroundColor: R.colors.yellow,
    borderTopLeftRadius: 15,
    borderTopRightRadius: 15,
    paddingLeft: 13,
    paddingVertical: 5

  },
  container_card: {
    marginVertical: 15,
    borderRadius: 15,
    marginHorizontal: 15,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
  },
  card_item: {
    backgroundColor: R.colors.white,
    borderBottomLeftRadius: 15,
    borderBottomRightRadius: 15,
    paddingHorizontal: 15,
    paddingVertical: 10,
    },
  header_card_item: {
    justifyContent: "space-between",
    flexDirection: "row",
  },
  text_title: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize14,
    fontWeight: "400",
    color: R.colors.black,
  },
  sub_text: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: "300",
    lineHeight: 24,
    color: R.colors.black,
  },
});
