import React, { useRef } from 'react';
import {
  View,
  Text,
  TextInput,
  StyleSheet,
  Platform,
} from 'react-native';
import R from '../../assets/R';

const CustomTextInput = (props) => {
  const { 
    title, 
    placeholder,
    required, 
    value,
    onChangeText,
    backgroundColor, // FUNCTIONALITY: Prop backgroundColor tùy chỉnh
    ...restProps 
  } = props;

  const inputRef = useRef(null);

  return (
    <View style={styles.container}>
      {/* FUNCTIONALITY: Title với sao đỏ nếu required */}
      {title && (
        <View style={styles.titleContainer}>
          <Text style={styles.title}>
            {title}
            {required && <Text style={styles.required}> *</Text>}
          </Text>
        </View>
      )}

      {/* FUNCTIONALITY: Input container với background tùy chỉnh */}
      <View style={[
        styles.inputContainer,
        backgroundColor && { backgroundColor } // NOTE: Chỉ apply backgroundColor khi có truyền vào
      ]}>
        <TextInput
          ref={inputRef}
          style={styles.input}
          placeholder={placeholder}
          placeholderTextColor={R.colors.grey_100}
          value={value}
          onChangeText={onChangeText}
          {...restProps}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  // FUNCTIONALITY: Container wrapper
  container: {
    width: '100%',
    marginVertical: 5
  },

  // UI/UX: Container cho title
  titleContainer: {
    flexDirection: 'row',
    marginBottom: 3,
  },

  // UI/UX: Title text
  title: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    color: R.colors.black
  },

  // UI/UX: Dấu sao đỏ bắt buộc
  required: {
    color: R.colors.red, 
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '500',
  },

  // UI/UX: Input container - KHÔNG có backgroundColor mặc định
  inputContainer: {
    // NOTE: Không set backgroundColor ở đây
    borderRadius: 10,
    borderWidth: 1,
    borderColor: R.colors.grey_200,
    paddingHorizontal: 15,
  },

  // UI/UX: Input text styles
  input: {
    fontSize: R.fontsize.fontsSize10,
    fontFamily: R.fonts.InterRegular,

    fontWeight: '400',
    color: R.colors.black, // FIXME: Đổi từ grey_200 sang black để text rõ hơn
    padding: 0,
    height: 30,
  },
});

export default CustomTextInput;
