import { useNavigation } from "@react-navigation/native";
import React from "react";
import { View, Text, StyleSheet, Image, TouchableOpacity } from "react-native";
import { DETAILROLLCALL } from "../../routers/ScreenNames";
import R from "../../assets/R";
const ItemList = ({ item }) => {
  const navigate = useNavigation();
  const IconNext = R.images.icArrowRight;
  return (
   <TouchableOpacity
      onPress={() => navigate.navigate(DETAILROLLCALL, { data: item })}
      style={styles.card_item} 
    >
      <View style={styles.content}>
          <Text style={styles.text}>Mã lớp:{item.class_code}</Text>
        <Text style={styles.text}>Tên môn: {item.subject_name}</Text>
        <View style={styles.footer}>
            <Text style={styles.text}>Tổng tiết: {item.total_lessons}</Text>
            <Text style={styles.text}>Số buổi vắng:{item.absent_count}</Text>
        </View>
      </View>
        <IconNext width={15} height={15} />
    </TouchableOpacity>
  );
};

export default ItemList;

const styles = StyleSheet.create({
  card_item: {
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
    marginVertical: 5,
    paddingHorizontal: 15,
    borderRadius: 10,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    shadowColor: R.colors.black,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
  },
  content: {
    flex: 1,
    paddingVertical:10
  },
  footer: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginRight:15
  },
  
  text:{
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '400',
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
  },
});
