import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  Modal,
  Animated,
  ScrollView
} from 'react-native';
import {styles} from './style';

const ModalBottomSheetView = props => {
  const {
    selectedDate,
    showBottomSheet,
    bottomSheetTranslateY,
    panResponder,
    parseLocalDate,
    formatDateToDisplay,
    handleCloseBottomSheet,
    getSelectedEvents,
  } = props;
  const renderBottomSheetContent = () => {
    if (!selectedDate || typeof selectedDate !== 'string') return null;

    const selectedDateObj = parseLocalDate(selectedDate);
    const selectedEvents = getSelectedEvents();

    return (
      <View style={styles.bottomSheetContent}>
        <View style={styles.dragHandle} />

        <View style={styles.bottomSheetHeader}>
          <Text style={styles.bottomSheetTitle}>
            {formatDateToDisplay(selectedDateObj)}
          </Text>
          <TouchableOpacity
            style={styles.closeButton}
            onPress={handleCloseBottomSheet}>
            <Text style={styles.closeButtonText}>✕</Text>
          </TouchableOpacity>
        </View>

        <ScrollView
          style={styles.eventsScrollView}
          showsVerticalScrollIndicator={false}>
          {selectedEvents.length === 0 ? (
            <View style={styles.noEventsContainer}>
              <Text style={styles.noEventsText}>Không có sự kiện nào</Text>
            </View>
          ) : (
            selectedEvents.map((event, index) => (
              <TouchableOpacity
                key={event.id}
                style={styles.eventCard}
                onPress={() =>
                  navigation.navigate(SCREENNAME.DETAILCLASSSCHEDULE, {event})
                }
                activeOpacity={0.7}>
                <View style={styles.eventTimeContainer}>
                  <Text style={styles.eventTime}>
                    {event.time}
                    {event.endTime && ` - ${event.endTime}`}
                  </Text>
                </View>

                <View style={styles.eventContent}>
                  <Text style={styles.eventTitle} numberOfLines={2}>
                    {event.title}
                  </Text>
                  {event.description && (
                    <Text style={styles.eventDescription} numberOfLines={3}>
                      {event.description}
                    </Text>
                  )}
                </View>
              </TouchableOpacity>
            ))
          )}
        </ScrollView>
      </View>
    );
  };
  return (
    <Modal
      visible={showBottomSheet}
      transparent={true}
      animationType="none"
      onRequestClose={handleCloseBottomSheet}>
      <TouchableOpacity
        style={styles.modalBackdrop}
        activeOpacity={1}
        onPress={handleCloseBottomSheet}>
        <Animated.View
          style={[
            styles.bottomSheet,
            {
              transform: [{translateY: bottomSheetTranslateY}],
            },
          ]}
          {...panResponder.panHandlers}>
          <TouchableOpacity activeOpacity={1}>
            {renderBottomSheetContent()}
          </TouchableOpacity>
        </Animated.View>
      </TouchableOpacity>
    </Modal>
  );
};

export default ModalBottomSheetView;
