import React from "react";
import { Text, View, StyleSheet } from "react-native";
import R from "../../assets/R";

const ItemView = ({ item, hasContentFlag, processedContent}) => {
   
  return (
    <View style={styles.container}>
      {item.type === "title" && (
        <Text style={styles.titleHeader}>{item.title}</Text>
      )}
      {item.type === "subTitle" && (
        <Text style={styles.subTitle}>{item.title}</Text>
      )}
       {hasContentFlag && processedContent}
    </View>
  );
};

export default ItemView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor:R.colors.white,
    paddingHorizontal: 15,
  },
  titleHeader: {
    fontSize: R.fontsize.fontsSize14,
    fontWeight: "bold",
    color: R.colors.blue500,
    fontFamily:R.fonts.InterSemiBold,
  },
  subTitle: {
    fontSize: R.fontsize.fontsSize14,
    fontWeight: "500",
    fontFamily:R.fonts.InterSemiBold,
    color: R.colors.blue500,
  },
  paragraph: {
    fontSize: R.fontsize.fontsSize10,
    color: R.colors.blue500,
    textAlign: "justify",
    fontFamily:R.fonts.InterSemiBold
  },
  listItem: {
    fontSize: R.fontsize.fontsSize10,
    lineHeight: 20,
    color: R.colors.blue500,
    fontFamily:R.fonts.InterSemiBold
  },
});
