import React from 'react';
import { Text, View, TouchableOpacity, StyleSheet, ImageBackground } from 'react-native';
import R from '../../../assets/R';
import { useNavigation } from '@react-navigation/native';
const DetailClassScheduleView = (props) => {
  const { } = props;
  const ArrowLeftIcon = R.images.icBack;
  const navigate = useNavigation();
  return (
    <SafeAreaView
      style={styles.container}>

      <ImageBackground
        source={R.images.igBackgroundSlider}
        style={styles.background_header}
      >
        <TouchableOpacity style={styles.back_button} onPress={() => navigate.goBack()}>
          <ArrowLeftIcon

          />
        </TouchableOpacity>
      </ImageBackground>
      <View style={styles.container_content}>
        <Text style={styles.text_title}>Lịch dạy lớp IT0032.47.T1</Text>
        <Text style={styles.text_content}>Thứ 6: 25/07/2025, 07:00 - 09:00</Text>
        <View style={[styles.container_content, { paddingHorizontal: 15, paddingVertical: 5 }]}>
          <Text style={styles.text_content}>Vị trí: Phòng B205</Text>
          <Text style={styles.text_content}>Sĩ số: 40</Text>
          <Text style={styles.text_content}>Lớp học: Thực hành</Text>
          <Text style={styles.text_content}>Hình thức học: Trực tiếp</Text>
        </View>
      </View>
    </SafeAreaView>
  );
};

export default DetailClassScheduleView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
  },
  back_button: {
    position: 'absolute',
    top: 20,
    left: 15,
  },
  background_header: {
    width: '100%',
    height: 178,
  },
  text_title: {
    fontSize: R.fontsize.fontsSize18,
    fontWeight: '500',
    fontFamily: R.fonts.InterRegular,
    color: R.colors.blue500,
  },
  container_content: {
    padding: 15,
  },
  text_content: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '500',
    fontFamily: R.fonts.InterSemiBold,
    color: R.colors.black,
  },
})