import React, { useEffect, useState } from "react";
import {
  DeviceEventEmitter,
  Image,
  StyleSheet,
  Text,
  TouchableOpacity,
  View,
} from "react-native";
import { createDrawerNavigator } from "@react-navigation/drawer";
import { connect } from "react-redux";
import ClassSchedule from "../../screens/class_schedule";
import FilterDateView from '../../screens/class_schedule/filter_date';
import * as ScreenName from "../ScreenNames";
import CustomDrawerContent from "./itemDrawer";
import R from "../../assets/R";
import FilterWeekView from "../../screens/class_schedule/filter_week/view";
import Filter3Date from "../../screens/class_schedule/filter_3_date";

const Drawer = createDrawerNavigator();
const ArrowLeft = R.images.icBack;
const IconMenu = R.images.icMenu;
const IconSearch = R.images.icSearch;

const DrawerNavigatorView = (props) => {
  const [reload, setReload] = useState(false);
  const [currentDate, setCurrentDate] = useState(new Date());

  const HeaderBackButton = ({ onPress, canGoBack }) => (
    <TouchableOpacity
      style={styles.headerBackButton}
      onPress={onPress}
      activeOpacity={0.7}
    >
      <ArrowLeft fill={"white"} />
    </TouchableOpacity>
  );

  useEffect(() => {
    const setLanguageListener = DeviceEventEmitter.addListener(
      "setLanguage",
      (value) => {
        setReload((prev) => !prev);
      }
    );

    const dateChangeListener = DeviceEventEmitter.addListener(
      "onDateChange",
      (date) => {
        setCurrentDate(new Date(date));
      }
    );

    return () => {
      setLanguageListener.remove();
      dateChangeListener.remove();
    };
  }, []);

  const MenuButton = ({ onPress }) => (
    <TouchableOpacity style={styles.menuButton} onPress={onPress}>
      <IconMenu width={24} height={24} stroke={R.colors.white}/>
    </TouchableOpacity>
  );

  const HeaderTitle = ({ navigation, route }) => {
    const getHeaderTitle = () => {
      if (route.name === ScreenName.FILTERDATE) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
        if (route.name === ScreenName.FILTER3DATE) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
        if (route.name === ScreenName.FILTERWEEK) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
 


      return '';
    };

    return (
      <TouchableOpacity style={styles.headerTitleButton}>
        <Text style={styles.headerTitleText}>
          {getHeaderTitle()}
        </Text>
      </TouchableOpacity>
    );
  };

  return (
    <Drawer.Navigator
      drawerContent={(drawerProps) => <CustomDrawerContent {...drawerProps} />}
      initialRouteName={ScreenName.CLASSSCHEDULE}
      screenOptions={({ navigation, route }) => ({
        headerLeft: () => (
          <View style={styles.headerLeftContainer}>
            <HeaderBackButton
              onPress={() => {
                if (navigation.canGoBack()) {
                  navigation.pop();
                } else {
                  navigation.toggleDrawer();
                }
              }}
              canGoBack={navigation.canGoBack()}
            />
            <MenuButton
              onPress={() => {
                navigation.toggleDrawer();
              }}
            />
          </View>
        ),

        headerTitle: () => (
          <HeaderTitle navigation={navigation} route={route} />
        ),

        headerRight: () => (
          <View style={styles.headerRightContainer}>
            <TouchableOpacity style={styles.searchButton}>
              <IconSearch stroke={R.colors.white} width={24} height={24} />
            </TouchableOpacity>
            <View style={styles.avatarButton} />
          </View>
        ),

        headerStyle: {
          backgroundColor: R.colors.blue500,
        },
      })}
    >
      <Drawer.Screen
        name={ScreenName.CLASSSCHEDULE}
        component={ClassSchedule}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: { height: 0 },
        }}
      />
      <Drawer.Screen
        name={ScreenName.FILTER3DATE}
        component={Filter3Date}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: { height: 0 },
        }}
      />
      <Drawer.Screen
        name={ScreenName.FILTERDATE}
        component={FilterDateView}
        options={{
          drawerItemStyle: { height: 0 },
        }}
      />
        <Drawer.Screen
        name={ScreenName.FILTERWEEK}
        component={FilterWeekView}
        options={{
          drawerItemStyle: { height: 0 },
        }}
      />
    </Drawer.Navigator>
  );
};

const mapStateToProps = (state) => ({
  user: state.userReducer,
});

const styles = StyleSheet.create({
  headerBackButton: {
    padding: 10,
    marginLeft: 10,
    borderRadius: 8,
  },
  menuButton: {
    padding: 10,
    marginLeft: 5,
  },
  headerLeftContainer: {
    flexDirection: "row",
    alignItems: "center",
  },
  headerRightContainer: {
    flexDirection: "row",
    alignItems: "center",
    marginRight: 15,
  },
  searchButton: {
    padding: 10,
    marginRight: 10,
  },
  avatarButton: {
    width: 30,
    height: 30,
    borderRadius: 30,
    backgroundColor: R.colors.white,
  },
  headerTitleButton: {
    alignItems: 'center',
    justifyContent: 'center',
  },
  headerTitleText: {
    fontSize: R.fontsize.fontsSize16,
    color: R.colors.white,
    fontFamily: R.fonts.InterMedium,
  },
});

export default connect(mapStateToProps, {})(DrawerNavigatorView);