import React, {useState} from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  ScrollView,
  FlatList,
} from 'react-native';
import Header from '../../../components/Header/Header';
import styles from './style';
import Button from '../../../components/Button';
import R from '../../../assets/R';

const DetailRollCallView = props => {
  const {sessionDates, studentsData} = props;

  return (
    <View style={styles.container}>
      <Header title={'Thống kê: ATTT2024.P1'} isBack />
      <View style={styles.body}>
        <ScrollView vertical showsVerticalScrollIndicator={false}>
          <View style={styles.btnGroup}>
            <Button
              title="Tạo QR điểm danh"
              onPress={() => {}}
              containerStyle={{
                paddingHorizontal: 5,
                paddingVertical: 5,
                borderRadius: 20,
              }}
              backgroundColor={R.colors.orange}
              textColor={R.colors.white}
              fontSize={12}
              height={35}
              width={150}
            />
            <Button />
            <Button
              title="Điểm danh"
              onPress={() => {}}
              containerStyle={{
                paddingHorizontal: 5,
                paddingVertical: 5,
                borderRadius: 20,
                marginLeft: 5,
              }}
              backgroundColor={R.colors.blue}
              textColor={R.colors.white}
              fontSize={12}
              height={35}
              width={150}
            />
            <Button />
          </View>

          <View>
            <Text style={styles.txt}>
              SL sinh viên nghỉ quá số lượng cho phép: <Text>3</Text>
            </Text>
            <Text style={styles.txt}>
              SL sinh viên đang bị cảnh báo: <Text>1</Text>
            </Text>
            <Text style={styles.txt}>
              SL sinh viên đủ điều kiện: <Text>3</Text>
            </Text>
          </View>

          <View>
            <Text
              style={[
                styles.txt,
                {
                  fontSize: R.fontsize.fontSizeSubTitle,
                  fontFamily: R.fonts.fontMedium,
                  fontWeight: '600',
                  color: R.colors.blue,
                },
              ]}>
              Kí hiệu
            </Text>
            <View
              style={{flexDirection: 'row', justifyContent: 'space-between'}}>
              <View>
                <Text style={[styles.txt, {color: R.colors.blue}]}>
                  (1){' '}
                  <Text
                    style={[
                      styles.txt,
                      {
                        color: R.colors.black,
                        fontFamily: R.fonts.fontMedium,
                        fontWeight: '600',
                      },
                    ]}>
                    Có mặt
                  </Text>
                </Text>
              </View>
              <View>
                <Text style={[styles.txt, {color: R.colors.red}]}>
                  (0){' '}
                  <Text
                    style={[
                      styles.txt,
                      {
                        color: R.colors.black,
                        fontFamily: R.fonts.fontMedium,
                        fontWeight: '600',
                      },
                    ]}>
                    Vắng mặt
                  </Text>
                </Text>
              </View>
              <View>
                <Text style={[styles.txt, {color: R.colors.blue}]}>
                  (*){' '}
                  <Text
                    style={[
                      styles.txt,
                      {
                        color: R.colors.black,
                        fontFamily: R.fonts.fontMedium,
                        fontWeight: '600',
                      },
                    ]}>
                    Chưa đến ngày
                  </Text>
                </Text>
              </View>
            </View>
          </View>

          <View>
            <Text style={styles.sectionTitle}>Danh sách</Text>

            <View style={styles.attendanceTableContainer}>
              <ScrollView horizontal showsHorizontalScrollIndicator={false}>
                <View style={styles.attendanceTable}>
                  {/* Header Row */}
                  <View style={styles.attendanceHeaderRow}>
                    <View
                      style={[
                        styles.attendanceHeaderCell,
                        styles.studentInfoColumn,
                      ]}>
                      <Text style={styles.attendanceHeaderText}>
                        Mã SV,{'\n'}Họ và tên
                      </Text>
                    </View>
                    {sessionDates.map((date, index) => (
                      <View
                        key={index}
                        style={[
                          styles.attendanceHeaderCell,
                          styles.dateColumn,
                        ]}>
                        <Text style={styles.attendanceHeaderText}>{date}</Text>
                      </View>
                    ))}
                  </View>

                  {/* Student Rows */}
                  {studentsData.map((student, studentIndex) => (
                    <View key={student.id} style={styles.attendanceDataRow}>
                      <View
                        style={[
                          styles.attendanceDataCell,
                          styles.studentInfoColumn,
                        ]}>
                        <Text style={styles.studentCodeText}>
                          {student.studentCode}
                        </Text>
                        <Text style={styles.studentNameText}>
                          {student.name}
                        </Text>
                        <Text
                          style={[
                            styles.percentageText,
                            {
                              color: student.percentage.includes('50%')
                                ? R.colors.red
                                : R.colors.green,
                            },
                          ]}>
                          {student.percentage}
                        </Text>
                      </View>
                      {student.attendance.map((status, dateIndex) => (
                        <View
                          key={dateIndex}
                          style={[
                            styles.attendanceDataCell,
                            styles.dateColumn,
                          ]}>
                          <Text
                            style={[
                              styles.attendanceStatusText,
                              {
                                color:
                                  status === 1
                                    ? R.colors.blue
                                    : status === 0
                                    ? R.colors.red
                                    : R.colors.gray2,
                              },
                            ]}>
                            {status}
                          </Text>
                        </View>
                      ))}
                    </View>
                  ))}
                </View>
              </ScrollView>
            </View>
          </View>
        </ScrollView>
      </View>
    </View>
  );
};

export default DetailRollCallView;
