import React, {useState} from 'react';
import {
  Modal,
  View,
  Text,
  TouchableOpacity,
  ScrollView,
  Image,
  FlatList,
} from 'react-native';
import R from '../../../assets/R';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import Button from '../../../components/Button';

const AddWorkModal = ({visible, onClose, onSave}) => {
  const [formData, setFormData] = useState({
    title: '',
    content: '',
    category: null,
    responsible: null,
    deadline: null,
    assignee: null,
    implementer: null,
    attachments: [],
  });

  const [dataList, setDataList] = useState([
    {id: 1, name: 'Nguyễn Minh Đức'},
    {id: 2, name: 'Trần Văn Hùng'},
    {id: 3, name: 'Lê Thị Mai'},
    {id: 4, name: 'Phạm Quốc Khánh'},
    {id: 5, name: 'Hoàng Anh Tuấn'},
    {id: 6, name: 'Vũ Thị Hằng'},
    {id: 7, name: 'Ngô Văn Nam'},
    {id: 8, name: 'Đinh Thị Lan'},
    {id: 9, name: 'Bùi Văn Phúc'},
    {id: 10, name: 'Lý Thị Hoa'},
    {id: 11, name: 'Phan Minh Hoàng'},
    {id: 12, name: 'Tạ Thị Hương'},
    {id: 13, name: 'Đoàn Văn Dũng'},
    {id: 14, name: 'Nguyễn Thị Vân'},
    {id: 15, name: 'Trương Văn Long'},
    {id: 16, name: 'Mai Thị Ngọc'},
    {id: 17, name: 'Huỳnh Quốc Việt'},
    {id: 18, name: 'Lâm Thị Thu'},
    {id: 19, name: 'Nguyễn Hữu Tài'},
    {id: 20, name: 'Phạm Thị Kim'},
  ]);

  const categoryData = [
    {name: 'Công việc theo văn bản', value: 'document'},
    {name: 'Công việc khác', value: 'other'},
  ];
  const items = [
    {id: 1, label: 'Option 1'},
    {id: 2, label: 'Option 2'},
    {id: 3, label: 'Option 3'},
  ];

  const responsibleData = [
    {name: 'Công việc theo văn bản', value: 'document'},
    {name: 'Công việc cá nhân', value: 'personal'},
  ];

  const assigneeData = [
    {name: 'BM255, Nguyễn Minh Đức', value: 'duc'},
    {name: 'Khác', value: 'other'},
  ];

  const implementerData = [
    {name: 'BM255, Nguyễn Minh Đức', value: 'duc'},
    {name: 'Khác', value: 'other'},
  ];

  const handleSave = () => {
    onSave(formData);
    onClose();
  };

  const handleCancel = () => {
    setFormData({
      title: '',
      content: '',
      category: null,
      responsible: null,
      deadline: null,
      assignee: null,
      implementer: null,
      attachments: [],
    });
    onClose();
  };
  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };
  return (
    <Modal
      visible={visible}
      animationType="slide"
      transparent={true}
      onRequestClose={onClose}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <ScrollView showsVerticalScrollIndicator={false}>
            <View style={styles.header}>
              <Text style={styles.headerTitle}>Thêm công việc</Text>
            </View>

            <View style={styles.formContainer}>
              <TextField
                title="Tiêu đề"
                required
                value={formData.title}
                containerMarginBottom={10}
              />

              <TextMulti
                title="Mô tả"
                required
                value={formData.content}
                containerMarginBottom={10}
                fontFamily={R.fonts.fontMedium}
                titleFontSize={R.fontsize.fontSizeContent}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Thẻ
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  placeholder="Công việc theo văn bản"
                  onSelect={item => console.log('Bạn đã chọn:', item)}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách thẻ đã chọn
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Văn bản liên quan
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  placeholder="Công việc theo văn bản"
                  onSelect={item => console.log('Bạn đã chọn:', item)}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách văn bản đã chọn
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <TextField
                title="Ngày đến hạn"
                required
                value={formData.title}
                containerMarginBottom={10}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Người theo dõi
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  onSelect={item => console.log('Bạn đã chọn:', item)}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách người theo dõi đã chọn
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Người thực hiện công việc
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  onSelect={item => console.log('Bạn đã chọn:', item)}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách người thực hiện công việc
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <View style={styles.buttonContainer}>
                <Button
                  title="Hủy"
                  textColor={R.colors.white}
                  onPress={handleCancel}
                  backgroundColor={R.colors.orange}
                  fontSize={R.sizes.sm}
                  fontFamily={R.fonts.fontMedium}
                  height={35}
                  width={100}
                  containerStyle={{paddingHorizontal: 15, borderRadius: 30}}
                />
                <Button
                  title="Thêm mới"
                  textColor={R.colors.white}
                  onPress={handleSave}
                  backgroundColor={R.colors.blue}
                  fontSize={R.sizes.sm}
                  fontFamily={R.fonts.fontMedium}
                  height={35}
                  width={100}
                  containerStyle={{borderRadius: 30}}
                />
              </View>
            </View>
          </ScrollView>
        </View>
      </View>
    </Modal>
  );
};

export default AddWorkModal;
