import React, {useState} from 'react';
import {Text, View, StyleSheet, Alert} from 'react-native';
import DetailIncomingDocumentView from './view';

const DetailIncomingDocument = props => {
  // Document data
  const [icomingDocument, setIncomingDocument] = useState({
    id: 102934,
    title: 'Văn bản thông báo lịch nộp thời khoá biểu của học kỳ 2 năm 2025',
    status: 'Hạn chế',
    symbol_number: '2038475',
    number_entry_book: '12493-fh544',
    term: '29/07/2025',
    term_display: '09/07/2025',
    document_date: '2025-07-08',
    document_date_display: '08/07/2025',
    document_type: 'Hành chính',
    field: 'Thời khoá biểu',
    signer_name: 'Nguyễn Minh Đức',
    sender_partner: 'Võ Công Bình',
    note: '',
    content:
      'Ban lãnh đạo yêu cầu hoàn thành thời khoá biểu trong tháng cho các đơn vị chuyên môn, nộp đầy đủ công việc theo đúng kế hoạch.',
    opinion_bgh: 'Thực hiện nhanh công tác thời khoá biểu',
    received_departments: [
      {id: 1, name: 'Phòng đào tạo'},
      {id: 2, name: 'Phòng đào tạo'},
    ],
    received_group: [{id: 12, name: 'Nhóm chuyên môn đào tạo'}],
    receiver: [{id: 55, name: 'Nguyễn Minh Đức'}],
    attachments: [
      {
        id: '001247363',
        filename: 'Quyết định thông báo đào tạo - 001247363',
        file_ext: 'pdf',
        file_size: 0,
        download_url: '#',
        preview_url: '#',
      },
    ],
    total_head_of_work: 7,
    approvals: [
      {
        author: 'Bút Tiến Công',
        code: '08569',
        date: '29/07/2025',
        time: '16:00',
        content:
          'Ban lãnh đạo yêu cầu hoàn thành thời khoá biểu trong tháng cho các đơn vị chuyên môn, nộp đầy đủ công việc theo đúng kế hoạch.',
      },
      {
        author: 'Nguyễn Thị Kim Phụng',
        code: '08569',
        date: '29/07/2025',
        time: '16:00',
        content: 'Trưởng phòng xác nhận hợp bộ hồ sơ.',
      },
      {
        author: 'Đặng Duy Minh',
        code: '08569',
        date: '29/07/2025',
        time: '16:00',
        content: 'Trưởng phòng nhập công bố quyết định nội bộ.',
      },
    ],
    actions: {
      can_create_task: true,
      create_task_label: 'Tạo công việc',
    },
  });

  // Dropdown data
  const items = [
    {id: 1, label: 'Option 1'},
    {id: 2, label: 'Option 2'},
    {id: 3, label: 'Option 3'},
  ];

  const [dataList, setDataList] = useState([
    {id: 1, name: 'Nguyễn Minh Đức'},
    {id: 2, name: 'Trần Văn Hùng'},
    {id: 3, name: 'Lê Thị Mai'},
    {id: 4, name: 'Phạm Quốc Khánh'},
    {id: 5, name: 'Hoàng Anh Tuấn'},
    {id: 6, name: 'Vũ Thị Hằng'},
    {id: 7, name: 'Ngô Văn Nam'},
    {id: 8, name: 'Đinh Thị Lan'},
    {id: 9, name: 'Bùi Văn Phúc'},
    {id: 10, name: 'Lý Thị Hoa'},
    {id: 11, name: 'Phan Minh Hoàng'},
    {id: 12, name: 'Tạ Thị Hương'},
    {id: 13, name: 'Đoàn Văn Dũng'},
    {id: 14, name: 'Nguyễn Thị Vân'},
    {id: 15, name: 'Trương Văn Long'},
    {id: 16, name: 'Mai Thị Ngọc'},
    {id: 17, name: 'Huỳnh Quốc Việt'},
    {id: 18, name: 'Lâm Thị Thu'},
    {id: 19, name: 'Nguyễn Hữu Tài'},
    {id: 20, name: 'Phạm Thị Kim'},
  ]);

  // Modal states
  const [showModal, setShowModal] = useState(false);
  const [showTaskModal, setShowTaskModal] = useState(false);
  
  // Annotation form states
  const [annotationContent, setAnnotationContent] = useState('');
  
  // Task form states
  const [taskTitle, setTaskTitle] = useState('');
  const [taskDescription, setTaskDescription] = useState('');
  const [taskCategory, setTaskCategory] = useState('Công việc theo văn bản');
  const [taskDeadline, setTaskDeadline] = useState('');
  const [taskFollower, setTaskFollower] = useState('859256, Nguyễn Minh Đức');
  const [taskExecutor, setTaskExecutor] = useState('859256, Nguyễn Minh Đức');
  const [selectedTags, setSelectedTags] = useState([]);
  const [selectedFollowers, setSelectedFollowers] = useState([]);
  const [selectedExecutors, setSelectedExecutors] = useState([]);
  const [errors, setErrors] = useState({});
  const [isSubmitting, setIsSubmitting] = useState(false);

  // Form validation function
  const validateForm = () => {
    const newErrors = {};
    if (!taskTitle.trim()) {
      newErrors.taskTitle = 'Tiêu đề không được để trống';
    }
    if (!taskDescription.trim()) {
      newErrors.taskDescription = 'Mô tả không được để trống';
    }
    if (!taskDeadline.trim()) {
      newErrors.taskDeadline = 'Ngày đến hạn không được để trống';
    }
    setErrors(newErrors);
    return Object.keys(newErrors).length === 0;
  };

  // Annotation handlers
  const handleAddAnnotation = () => {
    if (annotationContent.trim()) {
      Alert.alert('Thành công', 'Đã thêm bút phê thành công!');
      setAnnotationContent('');
      setShowModal(false);
    } else {
      Alert.alert('Lỗi', 'Vui lòng nhập nội dung bút phê!');
    }
  };

  // Task handlers
  const handleCreateTask = () => {
    if (!validateForm()) {
      Alert.alert('Lỗi', 'Vui lòng nhập đầy đủ thông tin!');
      return;
    }
    
    setIsSubmitting(true);
    
    try {
      const taskData = {
        title: taskTitle,
        description: taskDescription,
        category: taskCategory,
        deadline: taskDeadline,
        tags: selectedTags,
        followers: selectedFollowers,
        executors: selectedExecutors,
      };
      
      console.log('Creating task:', taskData);
      
      Alert.alert('Thành công', 'Đã tạo công việc thành công!');
      
      // Reset form after successful creation
      setTaskTitle('');
      setTaskDescription('');
      setTaskDeadline('');
      setSelectedTags([]);
      setSelectedFollowers([]);
      setSelectedExecutors([]);
      setErrors({});
      setShowTaskModal(false);
    } catch (error) {
      Alert.alert('Lỗi', 'Có lỗi xảy ra khi tạo công việc!');
      console.error('Error creating task:', error);
    } finally {
      setIsSubmitting(false);
    }
  };

  // Tag selection handlers
  const handleAddTag = item => {
    if (!selectedTags.find(t => t.id === item.id)) {
      setSelectedTags([...selectedTags, item]);
    }
  };

  const handleRemoveTag = id => {
    setSelectedTags(selectedTags.filter(item => item.id !== id));
  };

  // Follower selection handlers
  const handleAddFollower = item => {
    if (!selectedFollowers.find(f => f.id === item.id)) {
      setSelectedFollowers([...selectedFollowers, item]);
    }
  };

  const handleRemoveFollower = id => {
    setSelectedFollowers(selectedFollowers.filter(item => item.id !== id));
  };

  // Executor selection handlers
  const handleAddExecutor = item => {
    if (!selectedExecutors.find(e => e.id === item.id)) {
      setSelectedExecutors([...selectedExecutors, item]);
    }
  };

  const handleRemoveExecutor = id => {
    setSelectedExecutors(selectedExecutors.filter(item => item.id !== id));
  };

  return (
    <DetailIncomingDocumentView
      // Data props
      items={items}
      icomingDocument={icomingDocument}
      dataList={dataList}
      
      // Modal states
      showModal={showModal}
      setShowModal={setShowModal}
      showTaskModal={showTaskModal}
      setShowTaskModal={setShowTaskModal}
      
      // Annotation states
      annotationContent={annotationContent}
      setAnnotationContent={setAnnotationContent}
      
      // Task form states
      taskTitle={taskTitle}
      setTaskTitle={setTaskTitle}
      taskDescription={taskDescription}
      setTaskDescription={setTaskDescription}
      taskCategory={taskCategory}
      setTaskCategory={setTaskCategory}
      taskDeadline={taskDeadline}
      setTaskDeadline={setTaskDeadline}
      taskFollower={taskFollower}
      setTaskFollower={setTaskFollower}
      taskExecutor={taskExecutor}
      setTaskExecutor={setTaskExecutor}
      
      // Selection states
      selectedTags={selectedTags}
      selectedFollowers={selectedFollowers}
      selectedExecutors={selectedExecutors}
      
      // Form validation
      errors={errors}
      isSubmitting={isSubmitting}
      
      // Handlers
      handleAddAnnotation={handleAddAnnotation}
      handleCreateTask={handleCreateTask}
      handleAddTag={handleAddTag}
      handleRemoveTag={handleRemoveTag}
      handleAddFollower={handleAddFollower}
      handleRemoveFollower={handleRemoveFollower}
      handleAddExecutor={handleAddExecutor}
      handleRemoveExecutor={handleRemoveExecutor}
    />
  );
};

export default DetailIncomingDocument;
