import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  containerSearchBox: {
    borderColor: R.colors.grayBorderInputTextHeader,
    borderWidth: 1,
    borderRadius: 100,
    marginHorizontal: 15,
    marginVertical: 15,
    backgroundColor: R.colors.white,
    flexDirection: 'row',
    height: 35,
  },
  boxIconSearch: {
    maxWidth: 35,
    maxHeight: 35,
    alignItems: 'center',
    justifyContent: 'center',
    marginHorizontal: Platform.OS === 'ios' ? 5 : 10,
  },
  inputSearch: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '500',
    flex: 1,
    margin: 0,
    padding: 0,
  },
  statusContainer: {
    marginBottom: 15,
    marginHorizontal: 15,
    flexDirection: 'row',
    justifyContent: 'space-around',
  },
  statusCard: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  statusDot: {
    width: 10,
    height: 10,
    borderRadius: 5,
    marginRight: 5,
  },
  statusText: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
    marginRight: 5,
  },
  statusCount: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },

  body: {
    flex: 1,
  },
  listContainer: {
    paddingBottom: 20,
  },
  studentCard: {
    backgroundColor: R.colors.white,
    borderRadius: 15,
    marginBottom: 15,
    marginHorizontal: 15,
    padding: 15,

    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 2,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  studentCardContent: {
    flexDirection: 'row',
  },
  leftSection: {
    flex: 1,
    flexDirection: 'row',
    alignItems: 'center',
  },
  rightSection: {
    flex: 1,
    flexDirection: 'row',
    justifyContent: 'flex-end',
    alignItems: 'center',
  },
  genderIcon: {
    width: 15,
    height: 15,
    marginHorizontal: 5,
  },
  studentInfo: {
    flex: 1,
    flexDirection: 'row',
  },
  studentName: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },

  statusIndicator: {
    width: 15,
    height: 15,
    borderRadius: 15,
    marginLeft: 17,
  },
  sizedBox: {
    height: 5,
  },
});
export default styles;
