import React from 'react';
import {Text, View, TouchableOpacity, StyleSheet, FlatList} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import Button from '../../components/Button';
const SubTeacherView = props => {
  const {dataList, setDataList} = props;

  const renderItem = ({item}) => {
    return (
      <View style={styles.containerCard}>
        <View style={styles.containerText}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Mã lớp:{' '}
            <Text
              style={[
                styles.text,
                {
                  color: R.colors.blue,
                  fontWeight: '600',
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              {item.classCode}{' '}
            </Text>
          </Text>

          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Trạng thái:{' '}
            <Text
              style={[
                styles.text,
                {
                  color: getStatusColor(item.status),
                  fontWeight: '600',
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              {item.status}
            </Text>
          </Text>
        </View>
        <Text
          style={[
            styles.text,
            {
              fontSize: R.fontsize.fontSizeContent,
              fontWeight: 600,
              fontFamily: R.fonts.fontMedium,
            },
          ]}>
          Thời gian:{' '}
          <Text
            style={[
              styles.text,
              {fontWeight: '400', fontFamily: R.fonts.fontRegular},
            ]}>
            {item.time}
          </Text>
        </Text>

        <Text
          style={[
            styles.text,
            {
              fontSize: R.fontsize.fontSizeContent,
              fontWeight: 600,
              fontFamily: R.fonts.fontMedium,
            },
          ]}>
          Địa điểm:{' '}
          <Text
            style={[
              styles.text,
              {fontWeight: '400', fontFamily: R.fonts.fontRegular},
            ]}>
            {item.location}
          </Text>
        </Text>

        <Text
          style={[
            styles.text,
            {
              fontSize: R.fontsize.fontSizeContent,
              fontWeight: 600,
              fontFamily: R.fonts.fontMedium,
            },
          ]}>
          Giảng viên yêu cầu:{' '}
          <Text
            style={[
              styles.text,
              {fontWeight: '400', fontFamily: R.fonts.fontRegular},
            ]}>
            {item.requestedLecturer}
          </Text>
        </Text>

        <Text
          style={[
            styles.text,
            {
              fontSize: R.fontsize.fontSizeContent,
              fontWeight: 600,
              fontFamily: R.fonts.fontMedium,
            },
          ]}>
          Ghi chú:{' '}
          <Text
            style={[
              styles.text,
              {fontWeight: '400', fontFamily: R.fonts.fontRegular},
            ]}>
            {item.note}
          </Text>
        </Text>

        {item.status === 'Chờ xác nhận' && (
          <View style={styles.containerButton}>
            <Button
              title="Xác nhận"
              onPress={() => {}}
              backgroundColor={R.colors.blue}
              textColor={R.colors.white}
              height={30}
              borderRadius={15}
              fontSize={R.sizes.sm}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
              paddingHorizontal={15}
              paddingVertical={3}
              marginRight={10}
            />
            <Button
              title="Từ chối"
              onPress={() => {
                // Xử lý từ chối
              }}
              backgroundColor={R.colors.orange}
              textColor={R.colors.white}
              height={30}
              borderRadius={15}
              fontSize={R.sizes.sm}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
              paddingHorizontal={15}
              paddingVertical={3}
            />
          </View>
        )}
      </View>
    );
  };
  const getStatusColor = status => {
    switch (status) {
      case 'Chờ xác nhận':
        return R.colors.blue;
      case 'Đã xác nhận':
        return R.colors.green1;
      case 'Từ chối':
        return R.colors.orange;
    }
  };

  const renderCard = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Học kỳ 2, Năm 2025
          </Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderList = () => {
    return (
      <FlatList
        data={dataList || []}
        renderItem={renderItem}
        showsVerticalScrollIndicator={false}
        vertical
        keyExtractor={(item, index) => `${index}`}
      />
    );
  };

  const renderBody = () =>{
    return (
      <View style={styles.body}>
        {renderCard()}
        {renderList()}
      </View>
    )
  }
  return (
    <View style={styles.container}>
      <Header title={'Xác nhận dạy thay'} isBack />
        {renderBody()}
    </View>
  );
};

export default SubTeacherView;
