import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  Image,
  TextInput,
  FlatList,
} from 'react-native';
import R from '../../assets/R';
import styles from './style';
import Header from '../../components/Header/Header';
import {useNavigation} from '@react-navigation/native';
import * as SCREENNAME from '../../routers/ScreenNames';
import Button from '../../components/Button';

const ListRollCallView = props => {
  const {dataList} = props;
  const navigation = useNavigation();
  const renderItem = ({item}) => {
    return (
      <View style={styles.item}>
        <View style={styles.row}>
          <Text style={styles.textTitle}>
            Mã lớp:
            <Text
              style={[
                styles.text,
                {
                  color: R.colors.blue,
                  fontWeight: '600',
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              {item.classCode}
            </Text>
          </Text>
          <Text style={styles.textTitle}>
            Đã học / Tổng tiết:
            <Text style={[styles.text, {color: R.colors.blue}]}>
              {item.lessonLearned}/{item.generalDetails}
            </Text>
          </Text>
        </View>
        <View style={styles.row}>
          <Text style={styles.textTitle}>
            Sĩ số:{' '}
            <Text style={[styles.text, {color: R.colors.blue}]}>
              {item.numberOfStudent}
            </Text>
          </Text>
          <Text style={styles.textTitle}>
            Tổng số sv trượt điểm danh:{' '}
            <Text style={[styles.text, {color: R.colors.red}]}>
              {item.totalStudentFailedRollCall}
            </Text>
          </Text>
        </View>
        <Text style={styles.textTitle}>
          Ngày bắt đầu:{' '}
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.dateStart}
          </Text>
        </Text>
        <Text style={styles.textTitle}>
          Ngày kết thúc:{' '}
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.dateEnd}
          </Text>
        </Text>
        <View style={styles.btnContainer}>
          {item.status === 'Đang diễn ra' && (
            <Button
              title="Tạo QR điểm danh"
              onPress={() => {}}
              backgroundColor={R.colors.orange}
              textColor={R.colors.white}
              fontSize={12}
              containerStyle={{
                paddingHorizontal: 5,
                paddingVertical: 5,
                borderRadius: 20,
              }}
            />
          )}
          {item.status === 'Đang diễn ra' && (
            <View style={{alignItems: 'flex-end', flex: 1}}>
              <Button
                title="Điểm danh"
                onPress={() => {
                  navigation.navigate(SCREENNAME.LISTSTUDENTROLLCALL);
                }}
                containerStyle={{
                  paddingHorizontal: 5,
                  paddingVertical: 5,
                  borderRadius: 20,
                }}
                backgroundColor={R.colors.orange}
                textColor={R.colors.white}
                fontSize={12}
                width={85}
              />
            </View>
          )}
          <View style={{alignItems: 'flex-end', flex: 1}}>
            <Button
              title="Chi tiết"
              onPress={() => {
                navigation.navigate(SCREENNAME.DETAILROLLCALL);
              }}
              containerStyle={{
                paddingHorizontal: 5,
                borderRadius: 20,
                paddingVertical: 5,
              }}
              backgroundColor={R.colors.blue}
              textColor={R.colors.white}
              fontSize={12}
              width={85}
            />
          </View>
        </View>
      </View>
    );
  };

  const renderCard = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Học kỳ 2, Năm 2025
          </Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderFilter = () => {
    return (
      <View style={styles.searchContainer}>
        <Image source={R.images.icSearch} style={styles.iconSearch} />
        <TextInput
          placeholder="Tìm kiếm"
          placeholderTextColor={R.colors.grayText}
          style={styles.textInput}
        />
      </View>
    );
  };

  const renderListView = () => {
    return (
      <FlatList
        data={dataList}
        renderItem={renderItem}
        keyExtractor={(item, index) => `${index}`}
        showsVerticalScrollIndicator={false}
      />
    );
  };
  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderCard()}
        {renderFilter()}
        {renderListView()}
      </View>
    );
  };
  return (
    <View style={styles.container}>
      <Header title={'Danh sách lớp điểm danh'} isBack />
      {renderBody()}
    </View>
  );
};

export default ListRollCallView;
