import React, {useState} from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  FlatList,
  ScrollView,
  LogBox,
} from 'react-native';
import styles from './style';
import FAB from '../../../components/FAB/fab';
import SubButton from '../../../components/FAB/sub_button';
import R from '../../../assets/R';
import Header from '../../../components/Header/Header';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import Button from '../../../components/Button';
import ModalRequestReport from './modal_request_report';
import ModalRequestEditReport from './modal_request_edit_report';

const DetailListWorkMonitoringView = props => {
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const {
    data,
    dataList,
    dataReport,

    onOpenModalRequestReport,
    showModalRequestReport,
    onCloseModalRequestReport,
    onSubmitRequestReport,

    onOpenModalRequestEditReport,
    showModalRequestEditReport,
    onCloseModalRequestEditReport,
    onSubmitRequestEditReport,
  } = props;

  const getColor = status => {
    switch (status) {
      case 'Chờ duyệt':
        return R.colors.blue;
      case 'Hoàn thành':
        return R.colors.green1;
      case 'Đợi chỉnh sửa': 
        return R.colors.orange;
      case 'Đang thực hiện':
        return R.colors.orange;
      case 'Đợi báo cáo':
        return R.colors.blue;
      default:
        return R.colors.gray;
    }
  };

  const getColorCard = statusDocument => {
    switch (statusDocument) {
      case 'Đã phê duyệt':
        return R.colors.green1;
      case 'Chỉnh sửa':
        return R.colors.orange;
      default:
        return R.colors.gray;
    }
  };

  const getViewMode = () => {
    switch (data?.status) {
      case 'Đang thực hiện':
        return 'editing';
      case 'Đợi báo cáo':
        return 'review';
      case 'Chờ duyệt':
        return 'waiting';
      case 'Đợi chỉnh sửa':
        return 'waitingEdit';
      case 'Hoàn thành':
        return 'completed';
      default:
        return 'none';
    }
  };
  const mode = getViewMode();

  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity
          style={styles.containerIcon}
          onPress={() => handleItemPress(item)}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };



  const renderButton = () => {
    return (
        <Button
          title={ mode === 'editing' ? 'Cập nhật thông tin công việc' : 'Phê duyệt' }
          backgroundColor={R.colors.blue}
          textColor={R.colors.white}
          onPress={() => ({})}
          fontSize={R.sizes.sm}
          fontFamily={R.fonts.fontMedium}
          height={30}
          containerStyle={{paddingHorizontal: 15, borderRadius: 25, marginTop:30}}
        />
    );
  };

  const renderButtonDownloadDoc = () => {
    return (
      <TouchableOpacity style={styles.attachmentContainer}>
        <Image source={R.images.icDocument} style={styles.uploadIcon} />
        <Text style={styles.attachmentText}>Thêm tài liệu</Text>
      </TouchableOpacity>
    );
  };

  const renderListReport = () => {
    const reports = dataReport?.userSend ?? [];
    const responders = reports.flatMap(r => r?.responder ?? []);
    return (
      <View>
        <View>
          <Text
            style={[
              styles.text,
              {
                color: R.colors.blue,
                fontFamily: R.fonts.fontMedium,
                fontSize: R.fontsize.fontSizeSubTitle,
              },
            ]}>
            Báo cáo công việc
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {reports.map(item => item.title).join(', ')} -{' '}
            {reports.map(item => item.time).join(', ')}{' '}
            {reports.map(item => item.date).join(', ')}
          </Text>

          <View style={styles.cardContent}>
            <View
              style={{
                borderTopLeftRadius: 10,
                borderTopRightRadius: 10,
                paddingLeft: 10,
                backgroundColor: getColorCard(
                  reports.map(item => item.statusDocument).join(', '),
                ),
              }}>
              <Text
                style={[
                  styles.text,
                  {
                    color: R.colors.white,
                  },
                ]}>
                {reports.map(item => item.statusDocument).join(', ')}
              </Text>
            </View>
            
            <View style ={{ padding: 10,}} >
              <Text style={[styles.text]}>
                {responders.map(item => item.name).join(', ')} -{' '}
                {responders.map(item => item.time).join(', ')}{' '}
                {responders.map(item => item.date).join(', ')}{' '}
              </Text>
              <View style={styles.containerContent}>
                <Text style={[styles.text, {color: R.colors.gray4}]}>
                  {responders.map(item => item.content).join(', ')}
                </Text>
              </View>
              <TouchableOpacity style={styles.containerFile}>
                <Text style={[styles.text, {fontSize: R.sizes.xs}]}>
                  Quyết định thông báo đào tạo - QD347583
                </Text>
                <Image source={R.images.icDownload} style={styles.image} />
              </TouchableOpacity>
              <View style={{flexDirection: 'row', justifyContent: 'flex-end'}}>
                <Button
                  title="Yêu cầu chỉnh sửa"
                  backgroundColor={R.colors.orange}
                  textColor={R.colors.white}
                  onPress={() => {
                    onOpenModalRequestEditReport();
                  }}
                  fontSize={R.sizes.sm}
                  fontFamily={R.fonts.fontMedium}
                  height={30}
                  containerStyle={{
                    paddingHorizontal: 15,
                    borderRadius: 25,
                    marginRight: 5,
                  }}
                />
                <Button
                  title="Phê duyệt"
                  backgroundColor={R.colors.blue}
                  textColor={R.colors.white}
                  onPress={() => ({})}
                  fontSize={R.sizes.sm}
                  fontFamily={R.fonts.fontMedium}
                  height={30}
                  containerStyle={{paddingHorizontal: 15, borderRadius: 25}}
                />
              </View>
            </View>
          </View>
        </View>
      </View>
    );
  };

  const renderLoading = () => {
    return (
      <View style={styles.body}>
        <Text style={[styles.text, {textAlign: 'center'}]}>
          Xin hãy đợi thông tin phản hồi từ người thực hiện công việc ...
        </Text>
      </View>
    );
  };

  const renderBody = item => {
    return (
      <View style={styles.body}>
        <Text
          style={[
            styles.text,
            {fontSize: R.fontsize.fontSizeSubTitle, marginBottom: 3},
          ]}>
          {data.title}
        </Text>

        <Text style={[styles.text, {marginBottom: 3, textAlign: 'right'}]}>
          Trạng thái:{' '}
          <Text style={{color: getColor(data.status)}}>{data.status}</Text>
        </Text>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Công việc thuộc văn bản:{' '}
          <Text style={[styles.sub_text, {color: R.colors.blue}]}>
            {data.document}
          </Text>
        </Text>
        <Text style={[styles.text, {marginBottom: 3}]}>Nội dung công việc</Text>
        <View style={styles.containerContent}>
          <Text style={[styles.text, {color: R.colors.gray4}]}>
            {data.content}
          </Text>
        </View>
        <Text style={styles.text}>
          Ngày đến hạn <Text style={{color: R.colors.red}}>*</Text>
        </Text>
        <View style={styles.containerContent}>
          <Text style={styles.text}>{data.deadline}</Text>
        </View>

        <View style={styles.containerDropDown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
              },
            ]}>
            Người theo dõi
          </Text>
          <Dropdown
            height={35}
            items={item}
            placeholder="Công việc theo văn bản"
          />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách người theo dõi đã chọn
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <View style={styles.containerDropDown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
              },
            ]}>
            Người thực hiện công việc
          </Text>
          <Dropdown height={35} items={item} />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách người thực hiện công việc đã chọn
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <View style={styles.containerDropDown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
              },
            ]}>
            Thẻ
          </Text>
          <Dropdown height={35} items={item} />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách thẻ đã chọn
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <Text style={[styles.text, {marginBottom: 3}]}>Tài liệu đính kèm</Text>
        <TouchableOpacity style={styles.containerFile}>
          <Text style={[styles.text, {fontSize: R.sizes.xs}]}>
            Quyết định thông báo đào tạo - QD347583
          </Text>
          <Image source={R.images.icDownload} style={styles.image} />
        </TouchableOpacity>
        <>
          {mode === 'editing' && renderButtonDownloadDoc()}
          {mode === 'editing' && renderButton()}
          {mode === 'review' && renderLoading()}
          {(mode === 'waiting' || mode === 'waitingEdit' || mode === 'completed') && renderListReport()}
          {mode === 'waiting' && renderButton()}
        </>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Chi tiết công việc giám sát'} isBack={true} />
      <ScrollView showsVerticalScrollIndicator={false}>
        {renderBody()}
      </ScrollView>
      <>
        {mode === 'editing' && (
          <FAB>
            <SubButton
              onPress={onOpenModalRequestReport}
              label={'Yêu cầu báo cáo'}
              images={R.images.icEdit}
              backgroundColor={R.colors.orange}
            />
          </FAB>
        )}
      </>

      <ModalRequestReport
        visible={showModalRequestReport}
        onClose={onCloseModalRequestReport}
        onSubmitReport={onSubmitRequestReport}
        workData={data}
      />

      <ModalRequestEditReport
        visible={showModalRequestEditReport}
        onClose={onCloseModalRequestEditReport}
        onSubmitReport={onSubmitRequestEditReport}
      />
    </View>
  );
};

export default DetailListWorkMonitoringView;
