import React from 'react';
import {
  Modal,
  View,
  Text,
  TouchableOpacity,
  ScrollView,
  Image,
  FlatList,
} from 'react-native';
import R from '../../../assets/R';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import Button from '../../../components/Button';

const AddMonitoringModalView = props => {
  const {
    visible,
    formData,
    dataList,
    updateFormData,
    handleSave,
    handleClose,
  } = props;

  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  return (
    <Modal
      visible={visible}
      transparent={true}
      animationType="slide"
      onRequestClose={handleClose}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <ScrollView showsVerticalScrollIndicator={false}>
            <Text style={styles.title}>Thêm công việc</Text>

            <TextField
              title="Tiêu đề"
              required={true}
              value={formData.title}
              onChangeText={value => updateFormData('title', value)}
              containerMarginBottom={10}
            />

            <TextMulti
              title="Nội dung công việc"
              required={true}
              value={formData.content}
              onChangeText={value => updateFormData('content', value)}
              containerMarginBottom={10}
            />

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>Thẻ</Text>
              <Dropdown
                height={35}
                onSelect={item => updateFormData('responsible', item)}
              />
            </View>

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>Văn bản liên quan</Text>
              <Dropdown
                height={35}
                onSelect={item => updateFormData('deadline', item)}
              />
            </View>

            <TextField
              title="Ngày đến hạn"
              required={true}
              value={formData.content}
              onChangeText={value => updateFormData('content', value)}
              containerMarginBottom={15}
            />

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>
                Người theo dõi <Text style={styles.required}>*</Text>
              </Text>
              <Dropdown
                height={35}
                onSelect={item => updateFormData('implementer', item)}
              />
            </View>

            <Text style={styles.label}>Danh sách người theo dõi :</Text>
            <FlatList
              data={dataList}
              renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
              keyExtractor={(item, index) =>
                item.id?.toString() || index.toString()
              }
              numColumns={2}
              style={{maxHeight: 150, marginBottom: 10}}
              showsVerticalScrollIndicator={true}
              columnWrapperStyle={styles.flatListSelect}
              nestedScrollEnabled={true}
              scrollEnabled={true}
            />

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>
                Người thực hiện công việc <Text style={styles.required}>*</Text>
              </Text>
              <Dropdown
                height={35}
                onSelect={item => updateFormData('implementer', item)}
              />
            </View>
            <Text style={styles.label}>
              Danh sách người thực hiện công việc :
            </Text>
            <FlatList
              data={dataList}
              renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
              keyExtractor={(item, index) =>
                item.id?.toString() || index.toString()
              }
              numColumns={2}
              style={{maxHeight: 150, marginBottom: 10}}
              showsVerticalScrollIndicator={true}
              columnWrapperStyle={styles.flatListSelect}
              nestedScrollEnabled={true}
              scrollEnabled={true}
            />

            <Text style={styles.label}>Tài liệu đính kèm</Text>
            <TouchableOpacity style={styles.attachmentContainer}>
              <Image source={R.images.icDocument} style={styles.uploadIcon} />
              <Text style={styles.attachmentText}>Thêm tài liệu</Text>
            </TouchableOpacity>

            <View style={styles.buttonContainer}>
              <Button
                title="Hủy"
                onPress={handleClose}
                backgroundColor={R.colors.orange}
                width={100}
                height={35}
                borderRadius={100}
                marginRight={10}
                fontSize={R.fontsize.fontSizeContent}
                textColor={R.colors.white}
              />
              <Button
                title="Tạo công việc"
                onPress={handleSave}
                backgroundColor={R.colors.blue}
                width={120}
                height={35}
                borderRadius={100}
                fontSize={R.fontsize.fontSizeContent}
                textColor={R.colors.white}
              />
            </View>
          </ScrollView>
        </View>
      </View>
    </Modal>
  );
};

export default AddMonitoringModalView;
