import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  header: {
    backgroundColor: R.colors.blue,
    height: 50,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 15,
  },
  iconBack: {
    width: 25,
    height: 20,
  },
  iconDelete: {
    width: 25,
    height: 20,
  },
  title: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  avatarBox: {
    height: 50,
    flexDirection: 'row',
    marginVertical: 5,
  },
  avatarContainer: {
    width: 50,
    height: 50,
    borderRadius: 25,
  },
  avatar: {
    width: 50,
    height: 50,
    borderRadius: 25,
  },
  avatarTextContainer: {
    flex: 1,
    marginLeft: 10,
    paddingVertical: 2,
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  name: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  date: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.gray,
  },
  iconDrop: {
    width: 20,
    height: 20,
  },
  toMeContainer: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  detailSendContainer: {
    width: '100%',
    height: 200,
    backgroundColor: R.colors.blue4,
    borderRadius: 15,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  textTitleMail: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontBold,
    fontWeight: '600',
    color: R.colors.black,
  },
  textSubMail: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  textContent: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  iconReply: {
    width: 15,
    height: 15,
  },
  iconForward: {
    width: 15,
    height: 15,
  },
});
export default styles;
