import React from 'react';

import { DeviceEventEmitter, Image, StyleSheet, Text } from 'react-native';
import { TapGestureHandler , State} from 'react-native-gesture-handler';

import Animated , {
    useAnimatedStyle,
    useSharedValue,
  } from 'react-native-reanimated';

import {
  SUBBTN_BACKGROUND_COLOR,
  SUBBTN_BORDER_RADIUS,
  SUBBTN_HEIGHT,
  SUBBTN_WIDTH,
  SUBBTN_TAP_EVENT,
} from './constants';
import R from '../../assets/R';

// Component SubButton (nút con của FAB)
const SubButton =({
  label, 
  onPress, 
  images, 
  backgroundColor
})=> {

  // Biến sharedValue để quản lý độ mờ (opacity) khi nhấn giữ
  const buttonOpacity = useSharedValue(1);

  // Style động: cập nhật opacity theo buttonOpacity
  const animatedStyles = useAnimatedStyle(() => {
    return {
      opacity: buttonOpacity.value,
    };
  });

  // Hàm xử lý sự kiện khi người dùng tap SubButton
  function _onTapHandlerStateChange({ nativeEvent }) {
    switch (nativeEvent.state) {
        case State.BEGAN: { 
          // Khi bắt đầu nhấn -> giảm opacity để tạo hiệu ứng feedback
          buttonOpacity.value = 0.5;
          break;
        }
        case State.END: {
          // Khi nhấn xong -> phát sự kiện đóng FAB
          DeviceEventEmitter.emit(SUBBTN_TAP_EVENT);
          // Trả opacity về lại bình thường
          buttonOpacity.value = 1.0;
          // Gọi hàm onPress được truyền từ props
          onPress && onPress();
          break;
        }
        case State.CANCELLED: {
          // Nếu hủy tap -> trả opacity về 1
          buttonOpacity.value = 1.0;
          break;
        }
        case State.FAILED: {
          buttonOpacity.value = 1.0;
          break;
        }
        case State.UNDETERMINED: {
          buttonOpacity.value = 1.0;
          break;
        }
      }
  }

  return (
    // Bọc SubButton trong TapGestureHandler để xử lý cử chỉ chạm
    <TapGestureHandler onHandlerStateChange={_onTapHandlerStateChange}>
      <Animated.View style={[styles.subButton,{backgroundColor:backgroundColor} ,animatedStyles]}>
        <Text style={styles.label}>{label}</Text>
        <Image source={images} style={{width: 20, height: 20}} resizeMode="contain" tintColor={R.colors.white}/>
      </Animated.View>
    </TapGestureHandler>
  );
};

export default SubButton;

// Style cho SubButton
const styles = StyleSheet.create({
  subButton: {
    width: 150,                   // Chiều rộng nút con
    height: 35,                 // Chiều cao nút con
    borderRadius: SUBBTN_BORDER_RADIUS,    // Bo tròn (tròn hoàn hảo)
    backgroundColor: SUBBTN_BACKGROUND_COLOR, // Màu nền nút
    justifyContent: 'center',              // Canh giữa dọc
    marginTop: 10,                         // Khoảng cách giữa các SubButton4
    flexDirection: 'row',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
  },
  label: {
    marginRight:3,
    color: '#FFFFFF',                      // Màu chữ (trắng xanh nhạt)
    fontSize: 12,                          // Kích thước chữ
  },
});
