import {StyleSheet, Platform} from 'react-native';
import R from '../../assets/R';
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    
  },
  containerList: {
    flex: 1,
    justifyContent: 'center',
    
  },
  card: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 5,
    marginVertical:10,
    marginHorizontal: 15,
    alignItems: 'center',
    justifyContent: 'center',

    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  btnCard: {
    borderRadius: 10,
    borderWidth: 1,
    padding: 5,
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  text_title: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    color: R.colors.black,
    fontFamily: R.fonts.fontMedium,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  containerCard: {
    padding: 10,
    borderRadius: 10,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 1,
    elevation: Platform.OS === 'ios' ? 1 : 2,
    marginHorizontal: 15,
    marginVertical: 10,
  },
  containerEmpty: {
    alignItems: 'center',
    justifyContent: 'center',
  },
  textEmpty: {
    color: R.colors.black,
    fontSize: R.fontsize.fontSizeSubTitle,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
  },
  textHeader:{
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  containerText: {
    flexDirection: 'row',
  },
  sizedBox: {
    width: '35%',
  },
  containerButton: {
    alignItems: 'flex-end',
  },
});

export default styles;
