import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  FlatList,
  Image,
  TextInput,
} from 'react-native';
import Header from '../../components/Header/Header';
import styles from './style';
import R from '../../assets/R';
import * as SCREENNAME from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
const NotificationView = props => {
  const {
    dataTitleListTabView,
    activeTab,
    onTabChange,
    dataNotifi,
    getEmptyMessage,
    searchText,
    onSearchChange,
  } = props;
  const navigate = useNavigation();
  const getRenderItemFunction = () => {
    switch (activeTab) {
      case 'Tuition':
        return renderNotificationItemTution;
      default:
        return renderNotificationItemView;
    }
  };
  const getStatusColor = status => {
    switch (status) {
      case 'Đã gửi':
        return R.colors.green || '#4CAF50';
      case 'Chưa gửi':
        return R.colors.brown || '#8D6E63';
      default:
        return R.colors.gray || '#9E9E9E';
    }
  };
  const renderTabViewItem = ({item}) => {
    const isActivity = activeTab === item.key;
    return (
      <TouchableOpacity
        style={[styles.tabButtonItem, isActivity && styles.tabButtonActiveItem]}
        onPress={() => onTabChange(item.key)}>
        <Text style={styles.textTabView}>{item.title}</Text>
      </TouchableOpacity>
    );
  };
  const renderListTabView = () => {
    return (
      <View style={styles.tabButtonContainer}>
        <FlatList
          data={dataTitleListTabView}
          renderItem={renderTabViewItem}
          horizontal
          keyExtractor={(item, index) => `${activeTab}-${index}`}
          showsHorizontalScrollIndicator={false}
        />
      </View>
    );
  };
  const renderSearchBox = () => {
    return (
      <View style={styles.containerSearchBox}>
        <View style={styles.boxIconSearch}>
          <Image
            source={R.images.icSearchHeader}
            maxWidth={Platform.OS === 'ios' ? 16 : 20}
            maxHeight={Platform.OS === 'ios' ? 16 : 20}
            resizeMode="contain"
            tintColor={R.colors.gray}
          />
        </View>
        <TextInput
          placeholder="Tìm kiếm"
          value={searchText}
          onChangeText={onSearchChange}
          placeholderTextColor={R.colors.gray}
          color={R.colors.black}
          style={styles.inputSearch}
        />
      </View>
    );
  };
  const renderNotificationItemView = ({item}) => {
    return (
      <View style={styles.cardItem}>
        <Text style={styles.text} numberOfLines={1} ellipsizeMode="tail">
          {item.title_notifi}
        </Text>
        <Text style={styles.text} numberOfLines={2} ellipsizeMode="tail">
          {item.message}
        </Text>
        <View style={styles.boxTimeView}>
          <Text style={styles.text} numberOfLines={1} ellipsizeMode="tail">
            {item.time}
          </Text>
        </View>
      </View>
    );
  };
  const renderNotificationItemTution = ({item}) => {
    const statusColor = getStatusColor(item.status);
    return (
      <TouchableOpacity
        style={[styles.cardItem, styles.cardItemTution]}
        onPress={() => navigate.navigate(SCREENNAME.DETAILNOTIFICATION)}>
        <View style={styles.boxLeft}>
          <Text style={styles.text} numberOfLines={2} ellipsizeMode="tail">
            <Text
              style={[
                styles.text,
                {fontFamily: R.fonts.fontMedium, fontWeight: '600'},
              ]}>
              Tiêu đề:{' '}
            </Text>
            {item.title_notifi_tuition}
          </Text>

          <Text style={styles.text} numberOfLines={1} ellipsizeMode="tail">
            <Text
              style={[
                styles.text,
                {fontFamily: R.fonts.fontMedium, fontWeight: '600'},
              ]}>
              Ngày tạo:{' '}
            </Text>
            {item.date_create}
          </Text>

          <View style={styles.boxTimeTution}>
            <Text style={styles.text} numberOfLines={1} ellipsizeMode="tail">
              <Text
                style={[
                  styles.text,
                  {fontFamily: R.fonts.fontMedium, fontWeight: '600'},
                ]}>
                Thời gian gửi:{' '}
              </Text>
              {item.time_send}
            </Text>
            <Text
              style={[
                styles.text,
                {color: statusColor},
                {fontFamily: R.fonts.fontMedium, fontWeight: '600'},
              ]}
              numberOfLines={1}
              ellipsizeMode="tail">
              {item.status}
            </Text>
          </View>

          <Text style={styles.text} numberOfLines={1} ellipsizeMode="tail">
            <Text
              style={[
                styles.text,
                {fontFamily: R.fonts.fontMedium, fontWeight: '600'},
              ]}>
              Loại thông báo:{' '}
            </Text>
            {item.style}
          </Text>
        </View>
        <Image
          source={R.images.icNext}
          resizeMode="contain"
          style={{width: 10, height: 15, alignSelf: 'center'}}
        />
      </TouchableOpacity>
    );
  };

  const renderListNotification = () => {
    return (
      <FlatList
        data={dataNotifi[activeTab] || []}
        renderItem={getRenderItemFunction()}
        keyExtractor={(item, index) => `${activeTab}-${index}`}
        showsVerticalScrollIndicator={false}
        vertical
      />
    );
  };
  const renderItemEmpty = () => {
    return (
      <View style={styles.containerEmpty}>
        <Image source={R.images.icNoData} maxWidth={50} maxHeight={50} />
        <Text style={styles.textEmpty}>{getEmptyMessage(activeTab)}</Text>
      </View>
    );
  };
  const renderList = () =>{
    return (
         <View style={styles.containerBody}>

        {dataNotifi[activeTab].length === 0
          ? renderItemEmpty()
          : renderListNotification()}
      </View>
    )
  }
  return (
    <View style={styles.safeArea}>
      <Header title={'Thông báo'} />

      <View>
        {renderListTabView()}

        {renderSearchBox()}
      </View>

      {renderList()}

      <View style={styles.containerFooter}>
        <TouchableOpacity
          style={styles.btnFooter}
          onPress={() => navigate.navigate(SCREENNAME.ADDNOTIFICATION)}>
          <Text style={styles.textBtnFooter}>Tạo thông báo mới</Text>
        </TouchableOpacity>
      </View>
    </View>
  );
};

export default NotificationView;
