import React from 'react';
import {
  View,
  Text,
  ImageBackground,
  TouchableOpacity,
  FlatList,
  ScrollView,
  TouchableWithoutFeedback,
  Keyboard,
  Image,
} from 'react-native';
import HeaderCus from '../home/header';
import R from '../../assets/R';
import ItemGrid from './item';
import styles from './style';
import {useNavigation} from '@react-navigation/native';
import * as SCREENNAME from '../../routers/ScreenNames';
import { LogBox } from 'react-native';

const HomeView = ({
  menuActivity,
  menuStatistics,
  menuNotification,
  searchText,
  userProfile,
  onMenuItemPress,
  onSearchChange,
}) => {
  const navigate = useNavigation();
  LogBox.ignoreLogs([
    'VirtualizedLists should never be nested', 
    'Bottom Tab Navigator',
    'Stack Navigator',
  ]);

  const renderMenuItem = ({item}) => {
    return <ItemGrid item={item} onPress={() => onMenuItemPress(item)} />;
  };

  const cardItemInfo = () => {
    return (
      <View style={styles.profileCard}>
        <View style={styles.profile_left}>
          <View style={styles.avatar}>
            {userProfile?.avatar ? (
              <Image
                source={{uri: userProfile.avatar}}
                style={styles.avatar_image}
                resizeMode="cover"
              />
            ) : (
              <View style={styles.avatar_placeholder}>
                <Text style={styles.avatar_text}>
                  {userProfile?.name?.charAt(0) || 'U'}
                </Text>
              </View>
            )}
          </View>

          <View style={styles.information}>
            <Text
              style={styles.text_card_info}
              numberOfLines={1}
              ellipsizeMode="tail">
              {userProfile?.name ?? 'Không có dữ liệu'}
            </Text>
            <Text
              style={styles.text_card_info}
              numberOfLines={1}
              ellipsizeMode="tail">
              {userProfile?.phone ?? 'Không có dữ liệu'}
            </Text>
          </View>
        </View>

        <TouchableOpacity
          style={styles.profile_btn}
          onPress={() => navigate.navigate(SCREENNAME.PROFILE)}
          activeOpacity={0.7}>
          <Text style={styles.btn_text}>Hồ sơ cá nhân</Text>
          <View style={styles.iconNext}>
            <Image source={R.images.icNext} style={{width: 5, height: 10}} />
          </View>
        </TouchableOpacity>
      </View>
    );
  };

  const renderMenuActivity = () => {
    return (
      <View style={styles.menu_container}>
        <Text style={styles.menu_title}>Giảng dạy</Text>
        <FlatList
          data={menuActivity}
          renderItem={renderMenuItem}
          numColumns={3}
          keyExtractor={item => item.id.toString()}
          scrollEnabled={false}
          columnWrapperStyle={styles.row}
          ListEmptyComponent={renderItemEmpty}
          removeClippedSubviews={true}
          maxToRenderPerBatch={9}
        />
      </View>
    );
  };

  const renderMenuStatistics = () => {
    return (
      <View style={styles.menu_container}>
        <Text style={styles.menu_title}>Thống kê</Text>
        <FlatList
          data={menuStatistics}
          renderItem={renderMenuItem}
          numColumns={3}
          keyExtractor={item => item.id.toString()}
          scrollEnabled={false}
          columnWrapperStyle={styles.row}
          ListEmptyComponent={renderItemEmpty}
          removeClippedSubviews={true}
          maxToRenderPerBatch={9}
        />
      </View>
    );
  };

  const renderMenuNotification = () => {
    return (
      <View style={styles.menu_container}>
        <Text style={styles.menu_title}>Văn bản và thông báo</Text>
        <FlatList
          data={menuNotification}
          renderItem={renderMenuItem}
          numColumns={3}
          keyExtractor={item => item.id.toString()}
          scrollEnabled={false}
          columnWrapperStyle={styles.row}
          ListEmptyComponent={renderItemEmpty}
          removeClippedSubviews={true}
          maxToRenderPerBatch={9}
        />
      </View>
    );
  };

  const   renderItemEmpty = () => {
    return (
      <View style={styles.cardItemEmpty}>
        <Image source={R.images.icNoData} style={{width: 50, height: 50}} />
        <Text style={[styles.menu_text, {color: R.colors.red}]}>
          Không có dữ liệu
        </Text>
      </View>
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.container_body}>
        <ImageBackground
          source={R.images.igBackground}
          style={styles.background_header}>
          <HeaderCus value={searchText} onChangeText={onSearchChange} />
          {cardItemInfo()}
        </ImageBackground>

        <ScrollView
          showsVerticalScrollIndicator={false}
          style={styles.scroll}
          bounces={false}
          overScrollMode="never">
          {renderMenuActivity()}
          {renderMenuStatistics()}
          {renderMenuNotification()}
        </ScrollView>
      </View>
    );
  };

  return (
    <View style={styles.safeArea}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss} accessible={false}>
        {renderBody()}
      </TouchableWithoutFeedback>
    </View>
  );
};

export default HomeView;
