import {StyleSheet, Dimensions} from 'react-native';
import R from '../../../assets/R';

const {width} = Dimensions.get('window');
const DAY_COLUMN_WIDTH = (width - 70) / 7;

const styles = StyleSheet.create({
  // ==================== CONTAINER CHÍNH ====================
  // Tương ứng với View chính trong FilterWeekView (dòng 166)
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },

  // ==================== MONTH PICKER ====================
  // Tương ứng với renderMonthPicker() (dòng 19-49)
  monthPickerContainer: {
    backgroundColor: R.colors.white,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray,
    paddingVertical: 10,
  },
  monthPickerContent: {
    paddingHorizontal: 15,
  },
  monthItem: {
    paddingHorizontal: 20,
    paddingVertical: 8,
    marginRight: 10,
    borderRadius: 20,
    backgroundColor: R.colors.grayBorderInputTextHeader,
  },
  monthItemSelected: {
    backgroundColor: R.colors.blue,
  },
  monthItemText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
  },
  monthItemTextSelected: {
    color: R.colors.white,
    fontFamily: R.fonts.fontMedium,
  },

  // ==================== WEEK HEADER ====================
  // Tương ứng với renderWeekHeader() (dòng 51-87)
  weekHeaderContainer: {
    flexDirection: 'row',
    backgroundColor: R.colors.grayBorderInputTextHeader,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray,
  },
  timeColumnHeader: {
    width: 70,
  },
  dayHeaderCell: {
    width: DAY_COLUMN_WIDTH,
    alignItems: 'center',
    justifyContent: 'center',
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
    marginBottom: 5,
  },
  dayHeaderText: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  dayHeaderNumber: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    fontWeight: '600',
  },
  dayHeaderNumberContainerToday: {
    borderRadius: 15,
    justifyContent: 'center',
    alignItems: 'center',
  },
  dayHeaderNumberToday: {
    color: R.colors.white,
    fontFamily: R.fonts.fontMedium,
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    backgroundColor: R.colors.blue,
    borderRadius: 15,
    paddingHorizontal: 8,
    paddingVertical: 4,
  },
  dayHeaderTextToday: {
  },

  // ==================== TIME SLOTS CONTAINER ====================
  // Tương ứng với renderTimeSlots() (dòng 89-163)
  timeSlotsContainer: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  scrollContent: {
    paddingBottom: 50,
  },
  timelineContainer: {
    flexDirection: 'row',
    position: 'relative',
  },

  // ==================== TIME LABELS COLUMN ====================
  // Tương ứng với timeLabelsColumn (dòng 100-109)
  timeLabelsColumn: {
    width: 70,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
  },
  timeSlot: {
    height: 80,
    alignItems: 'center',
    justifyContent: 'center',
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray,
  },
  timeText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },

  // ==================== WEEK GRID CONTAINER ====================
  // Tương ứng với weekGridContainer (dòng 111-158)
  weekGridContainer: {
    flex: 1,
    flexDirection: 'row',
  },
  dayColumn: {
    width: DAY_COLUMN_WIDTH,
    position: 'relative',
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
  },
  gridCell: {
    height: 80,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray,
    width: '100%',
  },

  // ==================== EVENT CARDS ====================
  // Tương ứng với event rendering (dòng 118-155)
  eventCard: {
    borderRadius: 10,
    paddingHorizontal: 4,
    paddingVertical: 2,
    justifyContent: 'center',
  },
  eventTitle: {
    fontSize: R.fontsize.fontSizeBtn,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.white,
    fontWeight: '600',
    marginBottom: 1,
  },
  eventSubtitle: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.white,
    fontWeight: '400',
  },
  eventTime: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.white,
    fontWeight: '400',
  },
});

export default styles;
