import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  FlatList,
  Image,
} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
import * as ScreenName from '../../routers/ScreenNames';
const FeedBackView = props => {
  const {dataList, setDataList} = props;
  const navigation = useNavigation();
  const renderItem = ({item}) => {
    return (
      <TouchableOpacity
        onPress={() => {
          navigation.navigate(ScreenName.DETAILFEEDACK);
        }}
        style={styles.containerCard}>
        <View>
          <View>
            <Text
              style={[
                styles.text,
                {
                  fontWeight: '600',
                  fontFamily: R.fonts.fontMedium,
                  color: R.colors.blue,
                },
              ]}>
              Lớp: {item.classCode}
            </Text>
          </View>
          <View>
            <Text style={styles.text}>
              Mở đánh giá từ: {item.evaluationOpenDate}
            </Text>
          </View>
        </View>

        <View>
          <Text style={[styles.text]}>GPA: {item.gpa}</Text>
        </View>

        <View style={styles.btnRight}>
          <Image
            source={R.images.icNext}
            style={{width: 20, height: 20}}
            resizeMode="contain"
            tintColor={R.colors.black}
          />
        </View>
      </TouchableOpacity>
    );
  };
  return (
    <View style={styles.container}>
      <Header title={'Đánh giá giảng dạy'} isBack />
      <View style={styles.body}>
        <View style={styles.card}>
          <TouchableOpacity style={styles.btnCard}>
            <Text style={styles.text}>Học kỳ 2, Năm 2025</Text>
          </TouchableOpacity>
        </View>

        <FlatList
          data={dataList || []}
          renderItem={renderItem}
          showsVerticalScrollIndicator={false}
          vertical
          keyExtractor={(item, index) => `${index}`}
        />
      </View>
    </View>
  );
};

export default FeedBackView;
