import React, {Fragment, useRef, useEffect, useState} from 'react';
import {NavigationContainer} from '@react-navigation/native';
import {createStackNavigator} from '@react-navigation/stack';
import Home from '../screens/home';
import NotificationDetail from '../screens/notification/detail';
import TabNavigator from './TabNavigation';
import * as ScreenName from './ScreenNames';
import NotificationAdd from '../screens/notification/add';
import ClassActivity from '../screens/academic_advisor';
import ListStudentClass from '../screens/academic_advisor/list_student';
import DetailStudent from '../screens/academic_advisor/list_student/detail';
import SubTeacherView from '../screens/sub_teacher';
import ListFeedBack from '../screens/feedback';
import DetailFeedBack from '../screens/feedback/detail';
import ListRestReport from '../screens/list_rest_report';
import AbsenceListByCourse from '../screens/list_rest_report/detail';
import RegisterAbsence from '../screens/list_rest_report/add';
import CompensateView from '../screens/compensate';
import DetailCompensateView from '../screens/compensate/list'; 
import CompensateRegisterView from '../screens/compensate/register';
import DrawerNavigationView from '../routers/drawer_schedule';
import DetailClassSchedule from '../screens/class_schedule/detail';
import IncomingDocument from '../screens/incoming_document';
import DetailIncomingDocument from '../screens/incoming_document/detail';
import ListSendDocument from '../screens/list_send_document';
import EditSendDocument from '../screens/list_send_document/edit';
import AddSendDocument from '../screens/list_send_document/add';
import DetailSendDocument from '../screens/list_send_document/detail';
import StatusSendDocument from '../screens/list_send_document/status';
import ListWork from '../screens/list_work';
import DetailListWork from '../screens/list_work/detail';
import DrawerEmailView from '../routers/drawer_email/drawerView';
import SendEmail from '../screens/email/send';
import DetailEmail from '../screens/email/detail';
import ListRollCallView from '../screens/roll_call/';
import ListStudentRollCall from '../screens/roll_call/list_student_roll_call';
import DetailRollCall from '../screens/roll_call/detail';
import QrCode from '../screens/qr_code';
const Stack = createStackNavigator();

function MyStack(props) {
  return (
    <Stack.Navigator
      screenOptions={{
        headerStatusBarHeight: 0,
      }}
      headerMode={'none'}
      initialRouteName={ScreenName.TABNAVIGATOR}>
      <Stack.Screen name={ScreenName.HOMESCREEN} component={Home} />
      <Stack.Screen name={ScreenName.TABNAVIGATOR} component={TabNavigator} />
      <Stack.Screen name={ScreenName.DETAILNOTIFICATION} component={NotificationDetail} />
      <Stack.Screen name={ScreenName.ADDNOTIFICATION} component={NotificationAdd} />
      <Stack.Screen name={ScreenName.LISTACADEMICADVISOR} component={ClassActivity} />
      <Stack.Screen name={ScreenName.LISTSTUDENTCLASS} component={ListStudentClass} />
      <Stack.Screen name={ScreenName.DETAILSTUDENT} component={DetailStudent} />
      <Stack.Screen name={ScreenName.SUBTEACHER} component={SubTeacherView} />
      <Stack.Screen name={ScreenName.LISTFEEDBACK} component={ListFeedBack}/>
      <Stack.Screen name={ScreenName.DETAILFEEDACK} component={DetailFeedBack}/>
      <Stack.Screen name={ScreenName.LISTRESTREPORT} component={ListRestReport}/>
      <Stack.Screen name={ScreenName.ABSENCELISTBYCOURSE} component={AbsenceListByCourse}/>
      <Stack.Screen name={ScreenName.REGISTERABSENCE} component={RegisterAbsence}/>
      <Stack.Screen name={ScreenName.LISTMAKEUPCLASSES} component={CompensateView}/>
      <Stack.Screen name={ScreenName.MAKEUPSCHEDULELISTBYCOURSE} component={DetailCompensateView}/>
      <Stack.Screen name={ScreenName.REGISTERMAKEUP} component={CompensateRegisterView}/>
      <Stack.Screen name={ScreenName.DRAWERTABSCHEDULE} component={DrawerNavigationView}/>
      <Stack.Screen name={ScreenName.DETAILSCHEDULE} component={DetailClassSchedule}/>
      <Stack.Screen name={ScreenName.INCOMINGDOCUMENT} component={IncomingDocument}/>
      <Stack.Screen name={ScreenName.DETAILINCOMINGDOCUMENT} component={DetailIncomingDocument}/>
      <Stack.Screen name={ScreenName.LISTSENDDOCUMENT} component={ListSendDocument}/>
      <Stack.Screen name={ScreenName.EDITSENDDOCUMENT} component={EditSendDocument}/>
      <Stack.Screen name={ScreenName.ADDSENDOCUMENT} component={AddSendDocument}/>
      <Stack.Screen name={ScreenName.DETAILSENDDOCUMENT} component={DetailSendDocument}/>
      <Stack.Screen name={ScreenName.STATUSSENDDOCUMENT} component={StatusSendDocument}/>
      <Stack.Screen name={ScreenName.LISTWORK} component={ListWork}/>
      <Stack.Screen name={ScreenName.DETAILWORK} component={DetailListWork}/>
      <Stack.Screen name={ScreenName.EMAIL} component={DrawerEmailView}/>
      <Stack.Screen name={ScreenName.SENDEMAIL} component={SendEmail}/>
      <Stack.Screen name={ScreenName.DETAILEMAIL} component={DetailEmail}/>
      <Stack.Screen name={ScreenName.LISTROLLCALL} component={ListRollCallView}/>
      <Stack.Screen name={ScreenName.LISTSTUDENTROLLCALL} component={ListStudentRollCall}/>
      <Stack.Screen name={ScreenName.DETAILROLLCALL} component={DetailRollCall}/>
      <Stack.Screen name={ScreenName. QRCODE} component={QrCode}/>
    </Stack.Navigator>
  );
}

export default function App(props) {
  return (
    <Fragment>
      <NavigationContainer independent={true}>
        <MyStack />
      </NavigationContainer>
    </Fragment>
  );
}
