import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
    marginVertical: 10,
  },
  btnGroup: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
    marginBottom: 15,
  },
  sectionTitle: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.blue,
    marginBottom: 10,
    marginTop: 15,
  },
  attendanceTableContainer: {
    borderWidth: 1,
    borderColor: R.colors.gray3,
    marginBottom: 20,
  },
  attendanceTable: {
    minWidth: 800,
  },
  attendanceHeaderRow: {
    flexDirection: 'row',
    backgroundColor: R.colors.blue2,
    height: 60,
  },
  attendanceHeaderCell: {
    height: 60,
    paddingVertical: 8,
    paddingHorizontal: 4,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray3,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray3,
    justifyContent: 'center',
    alignItems: 'center',
  },
  attendanceHeaderText: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    textAlign: 'center',
  },
  attendanceDataRow: {
    flexDirection: 'row',
    height: 80,
  },
  attendanceDataCell: {
    height: 80,
    paddingVertical: 8,
    paddingHorizontal: 4,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray3,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray3,
    justifyContent: 'center',
    alignItems: 'center',
  },
  studentInfoColumn: {
    width: 120,
  },
  dateColumn: {
    width: 70,
  },
  studentCodeText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    textAlign: 'center',
    marginBottom: 2,
  },
  studentNameText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
    textAlign: 'center',
    marginBottom: 2,
  },
  percentageText: {
    fontSize: 10,
    fontFamily: R.fonts.fontMedium,
    textAlign: 'center',
  },
  attendanceStatusText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontBold,
    fontWeight: '700',
    textAlign: 'center',
  },
  txt: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  txtView:{
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  }
});

export default styles;
