import React, {useState, useMemo} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import NotificationView from './view';
import R from '../../assets/R';

const Notification = props => {
  //Xử lý tabView
  const dataListTabView = [
    {key: 'All', title: 'Tất cả'},
    {key: 'Study', title: 'Học tập'},
    {key: 'Activity', title: 'Hoạt động'},
    {key: 'Tuition', title: 'Học phí'},
  ];
  const [activeTab, setActiveTab] = useState('All');
  const [dataNotifi, setDataNotifi] = useState({
    All: [
      {
        title_notifi: 'Thông báo phân công giảng dạy',
        message:
          'Giảng viên nhận lịch phân công giảng dạy học kỳ Hè từ ngày 20/04',
        time: '14/04/2024',
      },
      {
        title_notifi: 'Thông báo họp khoa',
        message:
          'Khoa CNTT tổ chức họp giảng viên định kỳ tháng 4 vào 15/04 tại phòng A2',
        time: '15/04/2024',
      },
      {
        title_notifi: 'Thông báo chấm điểm',
        message:
          'Giảng viên hoàn thành chấm điểm học phần Cơ sở dữ liệu trước ngày 22/04',
        time: '18/04/2024',
      },
      {
        title_notifi: 'Thông báo hội đồng thi lại',
        message: 'Giảng viên được phân công coi và chấm thi lại ngày 25/04',
        time: '20/04/2024',
      },
      {
        title_notifi: 'Thông báo bảo trì hệ thống LMS',
        message: 'Hệ thống quản lý học tập bảo trì từ 0h - 6h ngày 22/04',
        time: '21/04/2024',
      },
      {
        title_notifi: 'Thông báo học bù',
        message:
          'Giảng viên bố trí lịch học bù cho lớp CNTT vào thứ 7 tuần này',
        time: '23/04/2024',
      },
      {
        title_notifi: 'Thông báo nộp điểm',
        message:
          'Hạn cuối giảng viên nộp điểm giữa kỳ môn Lập trình Java là 28/04',
        time: '24/04/2024',
      },
      {
        title_notifi: 'Thông báo nghiên cứu khoa học',
        message:
          'Giảng viên đăng ký đề tài NCKH năm học 2024 - 2025 trước 05/05',
        time: '26/04/2024',
      },
      {
        title_notifi: 'Thông báo hội thảo giảng dạy',
        message:
          'Mời giảng viên tham gia hội thảo phương pháp giảng dạy mới ngày 10/05',
        time: '02/05/2024',
      },
      {
        title_notifi: 'Thông báo tuyển cộng tác viên nghiên cứu',
        message:
          'Giảng viên có nhu cầu tuyển sinh viên hỗ trợ đề tài gửi danh sách trước 12/05',
        time: '05/05/2024',
      },
      {
        title_notifi: 'Thông báo nghỉ lễ',
        message: 'Giảng viên nghỉ lễ 30/04 - 01/05 theo quy định',
        time: '06/05/2024',
      },
      {
        title_notifi: 'Thông báo coi thi giữa kỳ',
        message: 'Phòng khảo thí gửi lịch phân công coi thi giữa kỳ ngày 15/05',
        time: '10/05/2024',
      },
      {
        title_notifi: 'Thông báo trả tài liệu',
        message:
          'Giảng viên mượn giáo trình tại thư viện vui lòng hoàn trả trước ngày 20/05',
        time: '14/05/2024',
      },
      {
        title_notifi: 'Thông báo đổi phòng học',
        message:
          'Môn Hệ điều hành chuyển sang giảng tại phòng B2.12 từ tuần sau',
        time: '16/05/2024',
      },
      {
        title_notifi: 'Thông báo hướng dẫn thực tập',
        message:
          'Giảng viên hướng dẫn sinh viên thực tập nộp kế hoạch trước 25/05',
        time: '19/05/2024',
      },
    ],
    Study: [],
    Activity: [],
    Tuition: [
      {
        title_notifi_tuition:
          'Các em lớp ATTT2024.1 lưu ý nộp học phí học kỳ 1 đúng hạn',
        date_create: '08:00 20/08/2025',
        time_send: '09:00 21/08/2025',
        style: 'Thông báo tập thể',
        status: 'Chưa gửi',
      },
      {
        title_notifi_tuition:
          'Thầy nhắc lớp ATTT2024.2 hoàn tất học phí học kỳ 2 trước ngày 25/08',
        date_create: '10:15 18/08/2025',
        time_send: '07:30 22/08/2025',
        style: 'Thông báo tập thể',
        status: 'Chưa gửi',
      },
      {
        title_notifi_tuition:
          'Sinh viên Nguyễn Văn A đã xác nhận hoàn thành học phí học kỳ 1',
        date_create: '14:30 17/08/2025',
        time_send: '09:00 20/08/2025',
        style: 'Thông báo cá nhân',
        status: 'Đã gửi',
      },
      {
        title_notifi_tuition:
          'Cô gia hạn nộp học phí cho lớp ATTT2024.3 đến ngày 30/08/2025',
        date_create: '09:40 19/08/2025',
        time_send: '08:00 23/08/2025',
        style: 'Thông báo tập thể',
        status: 'Chưa gửi',
      },
      {
        title_notifi_tuition:
          'Các em thuộc diện miễn giảm học phí nộp bổ sung giấy tờ trước 28/08',
        date_create: '15:20 16/08/2025',
        time_send: '10:00 21/08/2025',
        style: 'Thông báo tập thể',
        status: 'Đã gửi',
      },
      {
        title_notifi_tuition:
          'Danh sách sinh viên lớp ATTT2024.2 chưa hoàn thành học phí học kỳ 1',
        date_create: '11:00 15/08/2025',
        time_send: '09:00 22/08/2025',
        style: 'Thông báo tập thể',
        status: 'Chưa gửi',
      },
      {
        title_notifi_tuition:
          'Thầy gửi riêng: Em Trần Thị B kiểm tra lại học phí học kỳ 2',
        date_create: '16:45 14/08/2025',
        time_send: '08:30 21/08/2025',
        style: 'Thông báo cá nhân',
        status: 'Đã gửi',
      },
    ],
  });
  const handleTabChange = tabKey => {
    setActiveTab(tabKey);
  };
  const getEmptyMessage = tabKey => {
    const messages = {
      All: 'Chưa có thông báo nào',
      Study: 'Chưa có thông báo học tập',
      Activity: 'Chưa có thông báo hoạt động',
      Tuition: 'Chưa có thông báo học phí',
    };
    return messages[tabKey] || 'Không có dữ liệu';
  };

  const [searchText, setSearchText] = useState('');
  const handleSearchChange = text => {
    setSearchText(text);
  };

   const getStatusColor = status => {
    switch (status) {
      case 'Đã gửi':
        return R.colors.green1 ;
      case 'Chưa gửi':
        return R.colors.orange;
      default:
        return R.colors.gray ;
    }
  };

  const fitlerSearch = useMemo(() => {
    const list = dataNotifi[activeTab] || [];
    if (!searchText.trim()) return list;

    const searchLower = searchText.toLowerCase();

    return list.filter(item => {
      if (item.title_notifi) {
        return item.title_notifi.toLowerCase().includes(searchLower);
      }
      if (item.title_notifi_tuition) {
        return item.title_notifi_tuition.toLowerCase().includes(searchLower);
      }
      return false;
    });
  }, [dataNotifi, activeTab, searchText]);

  return (
    <NotificationView
      getStatusColor={getStatusColor}
      dataTitleListTabView={dataListTabView}
      activeTab={activeTab}
      onTabChange={handleTabChange}
      dataNotifi={{[activeTab]: fitlerSearch}}
      getEmptyMessage={getEmptyMessage}
      searchText={searchText}
      onSearchChange={handleSearchChange}
    />
  );
};

export default Notification;
