import {StyleSheet} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  overlay: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: 'white',
    borderRadius: 12,
    padding: 20,
    width: '90%',
    maxWidth: 400,
    maxHeight: '80%',
  },
  title: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '600',
    color: R.colors.blue,
    textAlign: 'center',
    marginBottom: 20,
  },
  containerDropdown: {
    marginBottom: 15,
  },
  label: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    marginBottom: 5,
  },
  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  required: {
    color: R.colors.red,
  },
  flatList: {
    maxHeight: 150,
    marginBottom: 10,
  },
  selectedFlatList: {
    maxHeight: 100,
    marginBottom: 15,
  },
  flatListRow: {
    justifyContent: 'space-between',
    paddingHorizontal: 5,
  },
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    backgroundColor: R.colors.blue2,
  },
  chipSelected: {
    backgroundColor: R.colors.blue1,
    borderColor: R.colors.blue,
  },
  selectedChip: {
    backgroundColor: R.colors.blue1,
    borderRadius: 20,
    paddingHorizontal: 10,
    paddingVertical: 8,
    margin: 5,
    borderWidth: 1,
    borderColor: R.colors.blue,
    flex: 0.48,
    flexDirection: 'row',
    alignItems: 'center',
  },
  textChip: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  textChipSelected: {
    color: R.colors.blue,
    fontWeight: '600',
  },
  containerIcon: {
    marginRight: 5,
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  attachmentContainer: {
    borderWidth: 1,
    borderColor: R.colors.blue,
    borderRadius: 10,
    padding: 20,
    alignItems: 'center',
    marginBottom: 20,
  },
  uploadIcon: {
    width: 23,
    height: 28,
    tintColor: R.colors.blue,
    marginBottom: 5,
  },
  attachmentText: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.blue,
    fontWeight: '500',
  },
  buttonContainer: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
    marginTop: 10,
  },
});

export default styles;
