import React from 'react';
import {Modal, View, Text, TouchableOpacity, Image} from 'react-native';
import R from '../../../../../assets/R';
import Button from '../../../../../components/Button';
import styles from './style';

const EditReportModalView = ({
  visible,
  onClose,
  reportContent,
  onContentChange,
  onSubmit,
  onCancel,
  onDeleteAttachment,
  onAddAttachment,
}) => {
  return (
    <Modal
      visible={visible}
      transparent={true}
      animationType="slide"
      onRequestClose={onClose}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <Text style={styles.title}>Chỉnh sửa báo cáo</Text>
          <Text style={styles.text}>
            Nội dung báo cáo
            <Text style={styles.required}>*</Text>
          </Text>
          <Text style={styles.description}>
            Bạn đã nộp yêu cầu nhưng thành thời khoa chưa trong thông cho cần
            đánh giá môn học các công việc và lịch hẹn quan
          </Text>

          <Text style={styles.text}>Tài liệu đính kèm</Text>

          <View style={styles.attachedFileContainer}>
            <Text style={styles.fileName}>
              Quyết định thông báo đào tạo - QD347583
            </Text>
            <TouchableOpacity onPress={onDeleteAttachment}>
              <Image source={R.images.icCancel} style={styles.deleteIcon} />
            </TouchableOpacity>
          </View>

          <TouchableOpacity
            style={styles.attachmentContainer}
            onPress={onAddAttachment}>
            <Image source={R.images.icDocument} style={styles.uploadIcon} />
            <Text style={styles.attachmentText}>Thêm tài liệu</Text>
          </TouchableOpacity>

          <View style={styles.buttonContainer}>
            <Button
              title="Hủy"
              onPress={onCancel}
              backgroundColor={R.colors.orange}
              width={100}
              height={35}
              borderRadius={100}
              marginRight={10}
              fontSize={R.fontsize.fontSizeContent}
              textColor={R.colors.white}
            />
            <Button
              title="Cập nhật"
              onPress={onSubmit}
              backgroundColor={R.colors.blue}
              width={100}
              height={35}
              borderRadius={100}
              fontSize={R.fontsize.fontSizeContent}
              textColor={R.colors.white}
            />
          </View>
        </View>
      </View>
    </Modal>
  );
};

export default EditReportModalView;
