import React, {useState} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import DetailStudentView from './view';

const DetailStudent = props => {
  const [student, setStudent] = useState({
    name: 'Nguyễn Minh Đức',
    code_student: '2598671',
    status: 'Đang học',
    date_student: '01/01/2000',
    tele_phone: '0123456789',
    gender: 'Nam',
    average_score: '8.5',
    latest_semester_average_score: '8.5',
    training_average_score: '100',
    type: [
      {
        id: 1,
        name: 'Chuẩn đầu ra NN',
        status: true,
      },
      {
        id: 2,
        name: 'Chuẩn trình NN',
        status: true,
      },
      {
        id: 3,
        name: 'Quá tiến độ học tập',
        status: false,
      },
      {
        id: 4,
        name: 'Nợ học phí',
        status: false,
      },
    ],
  });

  const handleCheckboxChange = (itemId, newValue) => {
    setStudent(prevStudent => {
      const updatedTypes = prevStudent.type.map(item => {
        if (item.id === itemId) {
          return {
            ...item,
            status: newValue,
          };
        } else {
          return item;
        }
      });
      return {
        ...prevStudent,
        type: updatedTypes,
      };
    });
  };

  return (
    <DetailStudentView
      student={student}
      onCheckboxChange={handleCheckboxChange}
    />
  );
};

export default DetailStudent;
