import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  Image,
  ScrollView,
} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import Button from '../../components/Button';
import TextField from '../../components/Input/TextField';
import RadioButton from '../../components/RadioButton/RadioButton';
import RadioGroup from '../../components/RadioButton/RadioGroup';

const ProfileView = props => {
  const {dataProfile, selectedValue2, options2, onValueChange2} = props;
  console.log(dataProfile?.name);
  return (
    <View style={styles.container}>
      <Header title={'Hồ sơ giảng viên'} isBack />
      <ScrollView showsVerticalScrollIndicator={false} vertical>
        <View style={styles.body}>
          <View style={styles.headerBody}>
            <View style={styles.headerLeft}>
              <View style={styles.boxCamera}>
                <View style={styles.containerImage}>
                  <Image source={R.images.iconCamera} style={styles.image} />
                </View>
                <View style={styles.containerButton}>
                  <Button
                    title="Chọn ảnh"
                    onPress={() => {}}
                    backgroundColor={R.colors.blue}
                    textColor={R.colors.white}
                    height={30}
                    borderRadius={10}
                    fontSize={R.sizes.sm}
                    fontWeight={'600'}
                    fontFamily={R.fonts.fontMedium}
                    paddingHorizontal={15}
                    paddingVertical={3}
                  />
                </View>
              </View>
            </View>

            <View style={styles.headerRight}>
              <Text
                style={[
                  styles.text,
                  {
                    lineHeight: 19,
                    fontSize: R.fontsize.fontsSizeTitle,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                    color: R.colors.blue,
                  },
                ]}>
                {dataProfile?.name || 'Không có dữ liệu'}
              </Text>
              <Text
                style={[styles.text, {fontSize: R.fontsize.fontsSizeSubTitle}]}>
                {dataProfile?.role || 'Không có dữ liệu'}
              </Text>
              <Text
                style={[
                  styles.text,
                  {
                    lineHeight: 24,
                    color: R.colors.blue,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Mã CBGV:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontWeight: '600', fontFamily: R.fonts.fontMedium},
                  ]}>
                  {dataProfile?.code || 'Không có dữ liệu'}
                </Text>
              </Text>
              <Text
                style={[
                  styles.text,
                  {
                    lineHeight: 24,
                    color: R.colors.blue,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Email:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontWeight: '600', fontFamily: R.fonts.fontMedium},
                  ]}>
                  {dataProfile?.email || 'Không có dữ liệu'}
                </Text>
              </Text>
              <Text
                style={[
                  styles.text,
                  {
                    lineHeight: 24,
                    color: R.colors.blue,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                TK chứng thực:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontWeight: '600', fontFamily: R.fonts.fontMedium},
                  ]}>
                  {dataProfile?.authCredential || 'Không có dữ liệu'}
                </Text>
              </Text>
              <Text
                style={[
                  styles.text,
                  {
                    lineHeight: 24,
                    color: R.colors.blue,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Đơn vị công tác:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontWeight: '600', fontFamily: R.fonts.fontMedium},
                  ]}>
                  {dataProfile?.department || 'Không có dữ liệu'}
                </Text>
              </Text>
              <Text
                style={[
                  styles.text,
                  {
                    lineHeight: 24,
                    color: R.colors.blue,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Bộ môn:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontWeight: '600', fontFamily: R.fonts.fontMedium},
                  ]}>
                  {dataProfile?.teachingUnit || 'Không có dữ liệu'}
                </Text>
              </Text>
            </View>
          </View>
          <View style={styles.bodyProfile}>
            <View style={styles.containerInput}>
              <TextField
                title={'Số điện thoại'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Mã CBGV cũ'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                width={'100%'}
                title={'Nơi công tác'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                width={'100%'}
                title={'Chức vụ'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                width={'100%'}
                title={'Vị trí kiêm nhiệm '}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                title={'Loại lao động'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Loại biên chế'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                title={'Quyết định bổ nhiệm'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Quyết định bổ nhiệm'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                title={'Cơ quan ban hành QĐ'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Công việc trước khi tuyển dụng'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={[styles.containerInput]}>
              <RadioGroup
                options={options2}
                selectedValue={selectedValue2}
                onValueChange={onValueChange2}
                disabled={false}
                size={20}
                backgroundBoxColor={R.colors.blue}
                borderBoxColor={R.colors.black}
                direction={'row'}
                marginBtnAndLabel={10}
                justifyContent={'space-around'}
                editable={true}
                containerWidth={'100%'}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Ngày hưởng PCTN'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                title={'PCTN công tác(%)'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'PCTN nhà giáo(%)'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Loại CBGV'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Đơn vị sinh hoạt chuyên môn'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Bộ môn sinh hoạt chuyên môn'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Trạng thái làm việc'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Ngày bắt đầu làm việc'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Loại hợp đồng hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Ngày BĐ HĐ hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Ngày KT HĐ hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Số hợp đồng hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Ngày HL HĐ hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Ngày BĐ làm việc CT'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Thời điểm xếp BL cuối'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'(%) PCTNVK hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Ngạch lương'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Bậc lương hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
              <View style={styles.sizedBox}></View>
              <TextField
                title={'Hệ số lương hiện hành'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                width={'48%'}
              />
            </View>
            <View style={styles.containerInput}>
              <TextField
                title={'Mốc nâng lương'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'48%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <View style={styles.containerInput}>
              <TextField
                title={'Chức danh giảng viên'}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                width={'100%'}
                containerBackgroundColor={R.colors.white}
              />
            </View>

            <Button
              title={'Lưu'}
              onPress={() => {}}
              backgroundColor={R.colors.blue}
              textColor={R.colors.white}
              fontSize={R.sizes.sm}
              paddingHorizontal={15}
              paddingVertical={5}
              borderRadius={10}
              fontSizeTitle={R.sizes.sm}
            />
          </View>
        </View>
      </ScrollView>
    </View>
  );
};

export default ProfileView;
