import {StyleSheet, Text, View} from 'react-native';
import R from '../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  card: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 5,
    marginTop: 15,
    marginBottom: 15,
    marginHorizontal: 15,
    alignItems: 'center',
    justifyContent: 'center',

    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  btnCard: {
    borderRadius: 10,
    borderWidth: 1,
    padding: 5,
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  container_tab_view:{
    marginVertical:5
  },
  item_tab_view:{
      backgroundColor: R.colors.gray,
      marginHorizontal: 5,
      borderRadius: 10,
      width: 107,
      justifyContent: 'center',
      alignItems: 'center',
  },
  active_tab_view:{
    backgroundColor: R.colors.blue,
  },
  text_tab_view:{
    color: R.colors.white,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    fontSize: R.fontsize.fontSizeContent,
  },
  text: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  searchBox: {
    flex: 1,
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 20,
    alignItems: 'center',
    justifyContent: 'flex-start',
    paddingLeft: 15,
    flexDirection: 'row',
    height: 42,
  },
  box_3: {
    flexDirection: 'row',
    marginHorizontal: 15,
    alignItems: 'center',
  },
  containerCard: {
    backgroundColor: R.colors.white,
    borderBottomLeftRadius: 15,
    paddingBottom: 10,
    borderBottomRightRadius: 15,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  subText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
});

export default styles;
