import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  ScrollView,
  Image,
  LogBox,
} from 'react-native';
import Header from '../../../components/Header/Header';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import R from '../../../assets/R';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import TextMulti from '../../../components/Input/TextMulti';
import Button from '../../../components/Button';
const RegisterAbsenceView = props => {
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const {} = props;
  return (
    <View style={styles.container}>
      <Header title={'Đăng ký báo nghỉ'} isBack />
      <ScrollView showsVerticalScrollIndicator={false} style={styles.body}>
        <View style={{marginBottom: 35}}>
          <View style={styles.containerInput}>
            <View style={{flex: 1}}>
              <TextField
                title={'Học kỳ'}
                required
                backgroundColor={R.colors.gray}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
              />
            </View>
            <View style={{flex: 0.1}}></View>
            <View style={{flex: 1}}>
              <TextField
                title={'Năm học'}
                required
                backgroundColor={R.colors.gray}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
              />
            </View>
          </View>
          <TextField
            title={'Mã CBGV'}
            required
            backgroundColor={R.colors.gray}
            color={R.colors.black}
            fontSize={R.sizes.sm}
            fontSizeTitle={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
          />
          <View style={styles.containerDropDown}>
            <View style={{flexDirection: 'row'}}>
              <Text
                style={[
                  styles.txtSubtitle,
                  {
                    marginBottom: 5,
                    fontSize: R.fontsize.fontSizeContent,
                    fontWeight: 600,
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Mã lớp{' '}
              </Text>
              <Text style={{color: R.colors.red}}>*</Text>
            </View>
            <Dropdown title={'Mã lớp '} />
          </View>
          <View style={styles.containerDropDown}>
            <View style={{flexDirection: 'row'}}>
              <Text
                style={[
                  styles.txtSubtitle,
                  {
                    marginBottom: 5,
                    fontSize: R.fontsize.fontSizeContent,
                    fontWeight: 600,
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Lịch báo nghỉ{' '}
              </Text>
              <Text style={{color: R.colors.red}}>*</Text>
            </View>
            <Dropdown title={'Lịch báo nghỉ '} />
          </View>

          <TextMulti
            title={'Lý do nghỉ'}
            required
            color={R.colors.black}
            fontSize={R.sizes.sm}
            titleFontSize={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            containerMarginTop={15}
          />
          <View style={styles.containerDropDown}>
            <View style={{flexDirection: 'row'}}>
              <Text
                style={[
                  styles.txtSubtitle,
                  {
                    marginBottom: 5,
                    fontSize: R.fontsize.fontSizeContent,
                    fontWeight: 600,
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Giảng viên thay thế
              </Text>
              <Text style={{color: R.colors.red}}>*</Text>
            </View>
            <Dropdown title={'Giảng viên thay thế'} />
          </View>

          <View style={{marginTop: 15}}>
            <Text
              style={[
                styles.txtSubtitle,
                {
                  marginBottom: 5,
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 600,
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              Minh chứng
            </Text>
            <TouchableOpacity style={styles.cardDocument}>
              <Image
                source={R.images.icDocument}
                style={{width: 30, height: 30}}
                resizeMode="contain"
              />
              <Text
                style={[
                  styles.txtSubtitle,
                  {
                    color: R.colors.blue,
                    fontWeight: '600',
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Thêm tài liệu
              </Text>
            </TouchableOpacity>
          </View>

          <Button
            title={'Đăng kí'}
            textColor={R.colors.white}
            onPress={() => {}}
            backgroundColor={R.colors.blue}
            fontSize={R.sizes.sm}
            fontFamily={R.fonts.fontMedium}
            height={35}
            containerStyle={{marginTop: 15, borderRadius: 10}}
          />
        </View>
      </ScrollView>
    </View>
  );
};

export default RegisterAbsenceView;
