import {StyleSheet, Text, View} from 'react-native';
import R from '../../../../assets/R';
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  containerCard: {
    marginHorizontal: 15,
    marginVertical: 5,
    borderRadius: 10,
  },
  card: {
    borderBottomEndRadius: 10,
    borderBottomStartRadius: 10,
    paddingHorizontal: 10,
    paddingVertical: 5,

    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 2,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },

  containerText: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    marginBottom: 5,
  },
  containerTextItemLeft: {
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    width: '45%',
  },
  containerTextItemRight: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  sizedBox: {
    flex: 3,
  },

  text: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
    textAlign: 'center',
  },
  containerSubText: {
    flexDirection: 'row',
    marginBottom: 5,
  },
  containerSubTextItemLeft: {},
  containerSubTextItemRight: {},
  textTitle: {
    fontSize: R.sizes.md,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.blue,
    marginHorizontal: 15,
  },
  label: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  checkboxContainer: {
    flexDirection: 'row',
    flexWrap: 'wrap',
    justifyContent: 'space-between',
  },
  checkboxItem: {
    width: '50%',
    marginBottom: 15,
  },
});

export default styles;
