import React, { useEffect, useState } from "react";
import {
  DeviceEventEmitter,
  Image,
  StyleSheet,
  Text,
  TouchableOpacity,
  View,
} from "react-native";
import { createDrawerNavigator } from "@react-navigation/drawer";
import { connect } from "react-redux";
import ClassSchedule from "../../screens/class_schedule";
import FilterDateView from '../../screens/class_schedule/filterday';
import * as ScreenName from "../ScreenNames";
import CustomDrawerContent from "./itemDrawer";
import R from "../../assets/R";
import FilterWeekView from "../../screens/class_schedule/filterWeek";
import Filter3Date from "../../screens/class_schedule/filter3day";

const Drawer = createDrawerNavigator();
const IconMenu = R.images.icMenu;
const IconSearch = R.images.icSearch;

const DrawerNavigatorView = (props) => {
  const [reload, setReload] = useState(false);
  const [currentDate, setCurrentDate] = useState(new Date());

  const HeaderBackButton = ({ onPress, canGoBack }) => (
    <TouchableOpacity
      style={styles.headerBackButton}
      onPress={onPress}
    >
        <Image source={R.images.icBack} resizeMode="contain" style={{width: 20, height: 20}}/>
    </TouchableOpacity>
  );

  useEffect(() => {
    const setLanguageListener = DeviceEventEmitter.addListener(
      "setLanguage",
      (value) => {
        setReload((prev) => !prev);
      }
    );

    const dateChangeListener = DeviceEventEmitter.addListener(
      "onDateChange",
      (date) => {
        setCurrentDate(new Date(date));
      }
    );

    const updateHeaderMonthListener = DeviceEventEmitter.addListener(
      "updateHeaderMonth",
      (monthIndex) => {
        const newDate = new Date(currentDate);
        newDate.setMonth(monthIndex);
        setCurrentDate(newDate);
      }
    );

    return () => {
      setLanguageListener.remove();
      dateChangeListener.remove();
      updateHeaderMonthListener.remove();
    };
  }, [currentDate]);

  const MenuButton = ({ onPress }) => (
    <TouchableOpacity style={styles.menuButton} onPress={onPress}>
      <Image source={IconMenu} style={styles.icon} resizeMode="contain" tintColor={R.colors.white}/>
    </TouchableOpacity>
  );

  const HeaderTitle = ({ navigation, route }) => {
    const getHeaderTitle = () => {
      if (route.name === ScreenName.FILTERDATE) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
        if (route.name === ScreenName.FILTER3DATE) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
        if (route.name === ScreenName.FILTERWEEK) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
      if (route.name === ScreenName.FILTERMONTH) {
        return `Tháng ${currentDate.getMonth() + 1}`;
      }
 


      return '';
    };

    return (
      <TouchableOpacity style={styles.headerTitleButton}>
        <Text style={styles.headerTitleText}>
          {getHeaderTitle()}
        </Text>
        <Image source={R.images.icDrop} style={{width: 25, height: 20}} resizeMode="contain" tintColor={R.colors.white}/>
      </TouchableOpacity>
    );
  };

  return (
    <Drawer.Navigator
      drawerContent={(drawerProps) => <CustomDrawerContent {...drawerProps} />}
      initialRouteName={ScreenName.FILTERMONTH}
      screenOptions={({ navigation, route }) => ({
        headerLeft: () => (
          <View style={styles.headerLeftContainer}>
            <HeaderBackButton
              onPress={() => {
                if (navigation.canGoBack()) {
                  navigation.pop();
                } else {
                  navigation.toggleDrawer();
                }
              }}
              canGoBack={navigation.canGoBack()}
            />
            <MenuButton
              onPress={() => {
                navigation.toggleDrawer();
              }}
            />
          </View>
        ),

        headerTitle: () => (
          <View style={styles.headerTitleContainer}>
            <HeaderTitle navigation={navigation} route={route} />
          </View>
        ),

        headerRight: () => (
          <View style={styles.headerRightContainer}>
            <TouchableOpacity style={styles.searchButton}>
              <Image source={IconSearch} style={styles.iconSearch} resizeMode="contain" tintColor={R.colors.white}/>
            </TouchableOpacity>
            <View style={styles.avatarButton} />
          </View>
        ),

        headerStyle: {
          backgroundColor: R.colors.blue,
        },
      })}
    >
      <Drawer.Screen
        name={ScreenName.FILTERMONTH} 
        component={ClassSchedule}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: { height: 0 },
        }}
      />
      <Drawer.Screen
        name={ScreenName.FILTER3DATE}
        component={Filter3Date}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: { height: 0 },
        }}
      />
      <Drawer.Screen
        name={ScreenName.FILTERDATE}
        component={FilterDateView}
        options={{
          drawerItemStyle: { height: 0 },
        }}
      />
        <Drawer.Screen
        name={ScreenName.FILTERWEEK}
        component={FilterWeekView}
        options={{
          drawerItemStyle: { height: 0 },
        }}
      />
    </Drawer.Navigator>
  );
};

const mapStateToProps = (state) => ({
  user: state.userReducer,
});

const styles = StyleSheet.create({
  headerBackButton: {
    marginLeft:15
  },
  menuButton: {
    marginLeft: 15,
  },
  headerLeftContainer: {
    flexDirection: "row",
    alignItems: "center",
  },
  headerRightContainer: {
    flexDirection: "row",
    alignItems: "center",
    marginRight: 15,
  },
  searchButton: {
    padding: 10,
    marginRight: 10,
  },
  avatarButton: {
    width: 25,
    height: 25,
    borderRadius: 30,
    backgroundColor: R.colors.white,
  },
  headerTitleButton: {
    alignItems: 'center',
    justifyContent: 'center',
    flexDirection: 'row',
  },
  headerTitleText: {
    fontSize: R.sizes.lg,
    color: R.colors.white,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
  },
  headerTitleContainer: {
    flexDirection: 'row',
  },
  icon: {
    width: 20,
    height: 20,
  },
  iconSearch: {
    width: 20,
    height: 20,
  },
});

export default connect(mapStateToProps, {})(DrawerNavigatorView);