// Vị trí bắt đầu của FAB (Floating Action Button)
export const FAB_STARTING_POSITION = 0;

// Kích thước chiều rộng của nút FAB
export const FAB_WIDTH = 50;

// Kích thước chiều cao của nút FAB (bằng với chiều rộng để tạo nút tròn)
export const FAB_HEIGHT = FAB_WIDTH;

// Bán kính bo tròn (FAB tròn hoàn hảo)
export const FAB_BORDER_RADIUS = FAB_WIDTH / 2;

// Màu nền mặc định của FAB
export const FAB_BACKGROUND_COLOR = '#2F6BFF';

// Khoảng cách margin của FAB với viền màn hình
export const FAB_MARGIN = -5;

export const LEFT_EDGE_SPACING = 110;


// -------- Trạng thái khi mở FAB --------

// Góc xoay của biểu tượng FAB khi mở (xoay 225 độ, thường là dấu "+" xoay thành "x")
export const FAB_ROTATION_OPEN = 225;

// Độ mờ của các nút con khi FAB mở (1 = hiện rõ)
export const FAB_CHILDREN_OPACITY_OPEN = 1;

// Vị trí Y của các nút con khi mở (0 = sát với FAB chính)
export const FAB_CHILDREN_POSITION_Y_OPEN = 0;

// Độ dịch chuyển Y của dấu "+" khi FAB mở (để canh giữa khi xoay)
export const FAB_PLUS_TRANSLATE_Y_OPEN = -3;


// -------- Trạng thái khi đóng FAB --------

// Độ mờ của các nút con khi FAB đóng (0 = ẩn hoàn toàn)
export const FAB_CHILDREN_OPACITY_CLOSE = 0;

// Vị trí Y của các nút con khi đóng (cách FAB chính 30px)
export const FAB_CHILDREN_POSITION_Y_CLOSE = 30;

// Góc xoay của FAB khi đóng (0 độ = trạng thái ban đầu)
export const FAB_ROTATION_CLOSE = 0;

// Độ dịch chuyển Y của dấu "+" khi FAB đóng
export const FAB_PLUS_TRANSLATE_Y_CLOSE = -2;


// -------- Cấu hình nút con (sub button) --------

// Chiều rộng nút con
export const SUBBTN_WIDTH = FAB_WIDTH;

// Chiều cao nút con (bằng chiều rộng để tạo hình tròn)
export const SUBBTN_HEIGHT = SUBBTN_WIDTH;

// Bán kính bo tròn (nút con hình tròn)
export const SUBBTN_BORDER_RADIUS = 10;

// Màu nền mặc định của nút con
export const SUBBTN_BACKGROUND_COLOR = '#2F6BFF';

// Tên sự kiện khi nhấn vào nút con
export const SUBBTN_TAP_EVENT = 'SUBBTN_TAP_EVENT';
