import React from 'react';
import {TouchableOpacity, View, Text, StyleSheet} from 'react-native';
import R from '../../assets/R';

const Chip = ({
  chipContainerStyle,
  index,
  onPress,
  chipImage,
  chipTextStyle,
  value,
  marginHorizontal,
  marginVertical = 3
}) => {
  const handlePress = () => {
    onPress(index);
  };
  return (
    <View
      onPress={handlePress}
      style={[{
        width: 'auto',
        paddingHorizontal: 5,
        paddingVertical: 5,
        marginLeft:3,
        borderRadius: 15,
        marginHorizontal: marginHorizontal,
        marginVertical: marginVertical,
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'center',
      }, chipContainerStyle]}>
      <Text style={[{
        fontSize: 12,
        color: R.colors.black,
      }, chipTextStyle]}>
        {value}
      </Text>

      {chipImage && (
        <View style={{marginLeft:5}}>
          {chipImage}
        </View>
      )}
    </View>
  );
};

export default React.memo(Chip);

