import React, {useState} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import DetailRollCallView from './view';

const DetailRollCall = props => {
  // Mock data - in real app this would come from API
  const [sessionDates] = useState([
    '30/06/2025',
    '06/07/2025',
    '13/07/2025',
    '20/07/2025',
    '27/07/2025',
    '04/08/2025',
    '11/08/2025',
    '18/08/2025',
    '25/08/2025',
    '04/09/2025',
  ]);

  const [studentsData] = useState([
    {
      id: 1,
      studentCode: '85964',
      name: 'Hoàng Lâm Anh',
      attendance: [1, 1, 1, 1, 1, 1, 1, 1, 1, '*'],
      percentage: '0%(0/18)',
    },
    {
      id: 2,
      studentCode: '85964',
      name: 'Vũ Tuấn Khải',
      attendance: [1, 1, 1, 1, 1, 1, 1, 1, 1, '*'],
      percentage: '0%(0/18)',
    },
    {
      id: 3,
      studentCode: '85964',
      name: 'Huỳnh Ngọc Lâm',
      attendance: [1, 1, 0, 1, 0, 1, 1, 1, 1, '*'],
      percentage: '22%(2/18)',
    },
    {
      id: 4,
      studentCode: '85964',
      name: 'Nguyễn Đức Mạnh',
      attendance: [1, 0, 0, 0, 0, 0, 1, 1, 1, '*'],
      percentage: '50%(9/18)',
    },
    {
      id: 5,
      studentCode: '85964',
      name: 'Vũ Thúy Linh',
      attendance: [1, 1, 1, 1, 1, 0, 0, 0, 0, '*'],
      percentage: '50%(9/18)',
    },
    {
      id: 6,
      studentCode: '85964',
      name: 'Vũ Hồng Nhung',
      attendance: [1, 1, 0, 0, 1, 1, 0, 1, 0, '*'],
      percentage: '50%(9/18)',
    },
  ]);
  return (
    <DetailRollCallView
      sessionDates={sessionDates}
      studentsData={studentsData}
    />
  );
};

export default DetailRollCall;
