import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
    marginVertical: 10,
  },
  row_1: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: 10,
    marginTop: 10,
  },
  sub_text: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '500',
    fontFamily: R.fonts.fontSemiBold,
    color: R.colors.black,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
  },

  containerDropdown: {
    marginBottom: 10,
    position: 'relative',
    zIndex: 1000,
  },
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    // position: 'relative',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    backgroundColor: R.colors.blue2,
    alignSelf: 'flex-start',
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  containerIcon: {
    marginRight: 2,
  },

  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  textChip: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  containerBtn: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-around',
    marginVertical: 10,
    borderRadius: 10,
    backgroundColor: R.colors.blue1,
    padding: 10,
    width: 350,
  },
  button: {
    borderRadius: 10,
    alignItems: 'center',
    justifyContent: 'center',
    marginVertical: 10,
    borderWidth: 1,
    borderColor: R.colors.blue1,
    height: 80,
  },
  textBtn: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
  },
});

export default styles;
