import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  textSubTitle: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  boxFeedBack: {
    backgroundColor: R.colors.grayButton,
    paddingVertical: 5,
    borderLeftWidth: 3,
    paddingLeft: 10,
    paddingRight: 10,
    borderLeftColor: R.colors.gray2,
  },
  containerQuestion: {
    marginVertical: 10,
  },
  tableContainer: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    backgroundColor: R.colors.white,
  },
  tableRow: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: R.colors.grayBorderInputTextHeader,
  },
  tableHeaderCellSmall: {
    flex: 0.5,
    padding: 8,
    backgroundColor: R.colors.blue3,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  tableHeaderCell: {
    flex: 1,
    padding: 8,
    borderRightWidth: 1,
    backgroundColor: R.colors.blue3,
    borderRightColor: R.colors.gray1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  tableCellSmall: {
    flex: 0.5,
    padding: 8,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  tableCell: {
    flex: 1,
    padding: 8,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  tableHeaderText: {
    fontSize: R.sizes.sm,
    fontWeight: 'bold',
    color: R.colors.black,
    textAlign: 'center',
  },
  tableCellText: {
    fontSize: R.sizes.xs,
    color: R.colors.black,
    textAlign: 'center',
    flexWrap: 'wrap',
  },
});

export default styles;
