import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  SafeAreaView,
} from 'react-native';
import Header from '../../../../components/Header/Header';
import R from '../../../../assets/R';
import styles from './style';
import {useNavigation} from '@react-navigation/native';
import CheckBox from '../../../../components/CheckBox';
const DetailStudentView = props => {
  const {student, onCheckboxChange} = props;
  const navigate = useNavigation();
  const getStatusColor = status => {
    const statusColors = {
      'Đang học': '#4CAF50',
      'Cảnh cáo': '#FF9800',
      'Thôi học': '#F44336',
    };
    return statusColors[status] || '#9E9E9E';
  };
  const statusColor = getStatusColor(student.status);
  
  return (
    <View style={styles.container}>
      <Header title={'Nguyễn Minh Đức - 2598671'} isBack />
      <View style={styles.body}>
        <View
          style={[
            styles.card,
            {marginHorizontal: 15, marginTop: 10, borderRadius: 10},
          ]}>
          <View style={styles.containerText}>
            <View style={styles.containerTextItemLeft}>
              <Text style={styles.text}>STC TL / STC CTDT 23 / 102</Text>
            </View>
            <View style={styles.sizedBox}></View>
            <View style={styles.containerTextItemRight}>
              <Text style={[styles.text]}>Tình trạng: </Text>
              <Text style={[styles.text, {color: statusColor}]}>
                {student.status}
              </Text>
            </View>
          </View>
          {/*Row 2*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Ngày sinh:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                  ]}>
                  {student.date_student}
                </Text>
              </Text>
            </View>
            <View style={styles.sizedBox}></View>
            <View style={styles.containerSubTextItemRight}>
              <Text style={[styles.text]}>
                SDT:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                  ]}>
                  {student.tele_phone}
                </Text>
              </Text>
            </View>
          </View>
          {/*Row 3*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Giới tính:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                  ]}>
                  {student.gender}
                </Text>
              </Text>
            </View>
            <View style={styles.sizedBox}></View>
            <View style={styles.containerSubTextItemRight}>
              <Text style={[styles.text]}>
                Điểm trung bình:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                  ]}>
                  {student.average_score}
                </Text>
              </Text>
            </View>
          </View>

          {/*Row 4*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Điểm TB học kì gần nhất:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                  ]}>
                  {student.average_score}
                </Text>
              </Text>
            </View>
          </View>
          {/*Row 5*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Điểm rèn luyện TB:{' '}
                <Text
                  style={[
                    styles.text,
                    {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                  ]}>
                  {student.training_average_score}
                </Text>
              </Text>
            </View>
          </View>

          {/*Row 6*/}
          <View style={styles.checkboxContainer}>
            {student.type.map((item, index) => (
              <View key={item.id} style={styles.checkboxItem}>
                <CheckBox
                  value={item.status}
                  onValueChange={value => onCheckboxChange(item.id, value)}
                  size={20}
                  labelStyle={styles.label}
                  checkedColor={R.colors.main}
                  tickColor={R.colors.white}
                  label={item.name}
                  imageStyle={styles.imageStyle}
                />
              </View>
            ))}
          </View>
        </View>
        <Text style={[styles.textTitle, {marginTop: 10}]}>
          Lịch sử tình trạng của sinh viên
        </Text>
        <View
          style={[
            styles.containerCard,
            {backgroundColor: getStatusColor(student.status)},
          ]}>
          <Text
            style={[
              {
                fontSize: R.sizes.sm,
                fontFamily: R.fonts.fontMedium,
                fontWeight: '600',
                color: R.colors.white,
                marginHorizontal: 10,
                marginVertical: 3,
              },
            ]}>
            Trạng thái học tập:{' '}
            <Text style={[styles.text, {color: R.colors.white}]}>
              {student.status}
            </Text>
          </Text>
          <View style={styles.card}>
            <Text
              style={[
                {
                  fontSize: R.sizes.sm,
                  fontFamily: R.fonts.fontMedium,
                  fontWeight: '600',
                  color: R.colors.black,
                },
              ]}>
              Học kỳ 2, Năm học 2024
            </Text>

            <Text
              style={[
                {
                  fontSize: R.sizes.sm,
                  fontFamily: R.fonts.fontMedium,
                  fontWeight: '600',
                  color: R.colors.black,
                },
              ]}>
              Ngày quyết định:{' '}
              <Text
                style={[
                  styles.text,
                  {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                ]}>
                {student.date_student}
              </Text>
            </Text>

            <Text
              style={[
                {
                  fontSize: R.sizes.sm,
                  fontFamily: R.fonts.fontMedium,
                  fontWeight: '600',
                  color: R.colors.black,
                },
              ]}>
              Lý do:{' '}
              <Text
                style={[
                  styles.text,
                  {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                ]}>
                {student.date_student}
              </Text>
            </Text>

            <Text
              style={[
                {
                  fontSize: R.sizes.sm,
                  fontFamily: R.fonts.fontMedium,
                  fontWeight: '600',
                  color: R.colors.black,
                },
              ]}>
              Ghi chú:{' '}
              <Text
                style={[
                  styles.text,
                  {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                ]}>
                {student.date_student}
              </Text>
            </Text>
          </View>
        </View>
      </View>
    </View>
  );
};

export default DetailStudentView;
