import {View } from 'react-native'
import React from 'react'
import RadioButton from './RadioButton'

const RadioGroup = ({
    options, // Giá trị của radio button
    selectedValue, // Giá trị đã chọn
    onValueChange, // Hàm callback khi giá trị thay đổi
    disabled, // Trạng thái disabled
    size, // Kích thước của radio button
    color, // Màu của radio button
    direction, // Hướng của radio button
    textColor,
    marginBtnAndLabel,
    containerMarginRight,
    justifyContent,
    containerMarginHorizontal,
    containerMarginVertical,
    containerMarginBottom,
    backgroundBoxColor,
    containerBoxColor,
    borderBoxColor,
    containerWidth,
    editable = false,
}) => {
  return (
    <View style={[
      {
        flexDirection: direction,
        justifyContent: justifyContent,
        marginHorizontal: containerMarginHorizontal,
        marginVertical: containerMarginVertical,
        marginBottom: containerMarginBottom,
        backgroundColor: containerBoxColor,
        width:containerWidth
      }
      ]}>
      {options.map((option, index) => (
        <RadioButton
          key={`${option.value}-${index}`}
          label={option.label}
          selected={option.value === selectedValue}
          onPress={() => editable ? onValueChange(option.value) : null}
          disable={disabled}
          size={size}
          color={color}
          textColor={textColor}
          marginBtnAndLabel={marginBtnAndLabel}
          containerMarginRight={containerMarginRight}
          backgroundBoxColor={backgroundBoxColor}
          borderBoxColor={borderBoxColor}
        />
      ))}
    </View>
  )
}

export default React.memo(RadioGroup) 
