import {StyleSheet} from 'react-native';
import R from '../../../../assets/R';

const styles = StyleSheet.create({
  // Modal styles
  modalOverlay: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: R.colors.white,
    borderRadius: 15,
    width: '90%',
    maxHeight: '80%',
    elevation: 5,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    padding:10
  },
  modalHeader: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    padding: 20,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.grayBorderInputTextHeader,
  },
  modalTitle: {
    fontSize: R.fontsize.fontSizeTitle,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.blue,
    textAlign:'center'
  },
  closeButton: {
    padding: 5,
  },
  closeIcon: {
    width: 20,
    height: 20,
    tintColor: R.colors.gray,
  },
  modalContent: {
    padding: 20,
    maxHeight: 400,
  },
  inputLabel: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    marginBottom: 8,
    marginTop: 15,
  },
  required: {
    color: R.colors.red,
  },
  textInput: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 12,
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
    backgroundColor: R.colors.white,
  },
  textArea: {
    height: 100,
    textAlignVertical: 'top',
  },
  dateInput: {
    flexDirection: 'row',
    alignItems: 'center',
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    paddingHorizontal: 12,
    backgroundColor: R.colors.white,
  },
  dateText: {
    flex: 1,
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
    paddingVertical: 12,
  },
  calendarIcon: {
    width: 20,
    height: 20,
    tintColor: R.colors.blue,
  },
  assigneeContainer: {
    flexDirection: 'row',
    flexWrap: 'wrap',
    marginTop: 8,
  },
  assigneeChip: {
    backgroundColor: R.colors.blue2,
    paddingHorizontal: 12,
    paddingVertical: 6,
    borderRadius: 15,
    marginRight: 8,
    marginBottom: 8,
  },
  assigneeText: {
    fontSize: R.fontsize.fontSizeSmall,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  modalFooter: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    padding: 20,
    borderTopWidth: 1,
    borderTopColor: R.colors.grayBorderInputTextHeader,
  },
  cancelButton: {
    flex: 1,
    backgroundColor: R.colors.white,
    borderWidth: 1,
    borderColor: R.colors.gray,
    borderRadius: 10,
    paddingVertical: 12,
    marginRight: 10,
    alignItems: 'center',
  },
  cancelButtonText: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.gray,
  },
  submitButton: {
    flex: 1,
    backgroundColor: R.colors.blue,
    borderRadius: 10,
    paddingVertical: 12,
    marginLeft: 10,
    alignItems: 'center',
  },
  submitButtonText: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.white,
  },
  buttonContainerStyle:{
    borderRadius:15,
    color:R.colors.white,
  },
  containerButton:{
    flexDirection:'row',
    justifyContent:'flex-end',
    alignItems:'center',
    marginTop:10
  }
});

export default styles;
