import React, {useState} from 'react';
import DetailListWorkMonitoringView from './view';

const DetailListWorkMonitoring = props => {
  const {route} = props;
  const workItem = route?.params?.workItem || {};
  const [showRequestReport, setShowRequestReport] = useState(false);

  const [data, setData] = useState({
    id: workItem.id || 1,
    title: workItem.title || 'Công việc giám sát',
    status: workItem.status || 'Đang thực hiện',
    deadline: workItem.deadline || '2025-09-04',
    assignee: workItem.assignee || [
      {
        id: 1,
        name: 'Nguyễn Văn A',
      },
      {
        id: 2,
        name: 'Trần Thị B',
      },
    ],
    implementer: workItem.implementer || [
      {
        id: 1,
        name: 'Nguyễn Văn A',
      },
      {
        id: 2,
        name: 'Trần Thị B',
      },
    ],
    document: workItem.document || 'Văn bản công việc giám sát',
    content:
      workItem.content ||
      'Nội dung công việc đang được giám sát và theo dõi tiến độ thực hiện',
  });

  const [dataList, setDataList] = useState([
    {id: 1, name: 'Nguyễn Minh Đức'},
    {id: 2, name: 'Trần Văn Hùng'},
    {id: 3, name: 'Lê Thị Mai'},
    {id: 4, name: 'Phạm Quốc Khánh'},
    {id: 5, name: 'Hoàng Anh Tuấn'},
  ]);

  const [dataReport, setDataReport] = useState([
    {
      id: 1,
      title: 'Báo cáo tiến độ lần 1',
      time: '14:30',
      date: '2025-09-10',
      content:
        'Báo cáo tiến độ thực hiện công việc được giao. Hiện tại đã hoàn thành 60% công việc theo kế hoạch.',
      fileTitle: 'Báo cáo tiến độ - BC001',
      responder: [
        {
          id: 1,
          name: 'Nguyễn Văn A',
          code: '12345',
          time: '14:30',
          date: '2025-09-10',
          content:
            'Đã hoàn thành phần phân tích yêu cầu và đang triển khai thiết kế hệ thống.',
        },
      ],
    },
    {
      id: 2,
      title: 'Báo cáo tiến độ lần 2',
      time: '16:00',
      date: '2025-09-12',
      content:
        'Cập nhật tiến độ thực hiện. Đã hoàn thành 80% công việc, dự kiến hoàn thành đúng hạn.',
      fileTitle: 'Báo cáo tiến độ - BC002',
      responder: [
        {
          id: 1,
          name: 'Nguyễn Văn A',
          code: '12345',
          time: '16:00',
          date: '2025-09-12',
          content:
            'Đã hoàn thành phần thiết kế và đang trong giai đoạn kiểm thử hệ thống.',
        },
      ],
    },
  ]);

  const handleReportPress = () => {
    if (data.status === 'Đang thực hiện') {
      setShowRequestReport(true);
    }
  };

  const handleCloseModalRequestReport = () => {
    setShowRequestReport(false);
  };

  const handleSubmitRequestReport = reportData => {
    setShowRequestReport(false);
  };

  return (
    <DetailListWorkMonitoringView
      data={data}
      dataList={dataList}
      dataReport={dataReport}
      onOpenModalRequestReport={handleReportPress}
      showModalRequestReport={showRequestReport}
      onCloseModalRequestReport={handleCloseModalRequestReport}
      onSubmitRequestReport={handleSubmitRequestReport}
    />
  );
};

export default DetailListWorkMonitoring;
