import React from 'react';
import FilterDayView from './view';
import {useFilterDay} from '../../../hooks/useFilterDay';

// HOISTED: function declaration (an toàn gọi ở mọi nơi bên dưới)
function createMockEvents() {
  const today = new Date();
  const formatDateToString = (date) => {
    const y = date.getFullYear();
    const m = String(date.getMonth() + 1).padStart(2, '0');
    const d = String(date.getDate()).padStart(2, '0');
    return `${y}-${m}-${d}`;
  };

  const todayStr = formatDateToString(today);
  const tomorrow = new Date(today); tomorrow.setDate(today.getDate() + 1);
  const tomorrowStr = formatDateToString(tomorrow);
  const yesterday = new Date(today); yesterday.setDate(today.getDate() - 1);
  const yesterdayStr = formatDateToString(yesterday);

  return [
    { id:'1', title:'Lịch vào trực lớp TTCĐT 445.T1', subtitle:'CS Địa lý 4D', time:'07:00', endTime:'09:00', date:todayStr, type:'class' },
    { id:'2', title:'Meeting team development', subtitle:'Phòng họp A1', time:'10:00', endTime:'11:30', date:todayStr, type:'meeting' },
    { id:'3', title:'Nghỉ giải lao', subtitle:'Thư giãn', time:'11:30', endTime:'12:30', date:todayStr, type:'break' },
    { id:'3a', title:'Đang ngủ', subtitle:'Thư giãn', time:'12:30', endTime:'13:30', date:todayStr, type:'break' },
    { id:'4', title:'Ăn trưa', subtitle:'Căng tin trường', time:'12:00', endTime:'13:00', date:todayStr, type:'meal' },
    { id:'4a', title:'Họp với phụ huynh', subtitle:'Phòng 101', time:'12:15', endTime:'13:15', date:todayStr, type:'meeting' },
    { id:'4b', title:'Chấm bài kiểm tra', subtitle:'Văn phòng', time:'12:30', endTime:'14:00', date:todayStr, type:'grading' },
    { id:'5', title:'Training React Native', subtitle:'Online Zoom', time:'14:00', endTime:'16:00', date:todayStr, type:'training' },
    { id:'6', title:'Code Review Session', subtitle:'Dev Team', time:'16:30', endTime:'17:30', date:todayStr, type:'review' },
    { id:'7', title:'Code Review Session', subtitle:'Dev Team', time:'16:30', endTime:'17:30', date:todayStr, type:'review' },
    { id:'6a', title:'Cuộc gọi với khách hàng', subtitle:'Online', time:'16:45', endTime:'17:15', date:todayStr, type:'call' },
    { id:'6b', title:'Chuẩn bị tài liệu', subtitle:'Văn phòng', time:'17:00', endTime:'18:00', date:todayStr, type:'preparation' },
    { id:'7', title:'Họp nội bộ khoa CNTT', subtitle:'Phòng họp B2', time:'08:00', endTime:'10:00', date:tomorrowStr, type:'meeting' },
    { id:'8', title:'Lịch học lớp EWC45.364.L1', subtitle:'Tiếng Anh chuyên ngành', time:'10:30', endTime:'12:00', date:tomorrowStr, type:'class' },
    { id:'9', title:'Workshop AI trong giáo dục', subtitle:'Hội trường lớn', time:'13:30', endTime:'17:00', date:tomorrowStr, type:'workshop' },
    { id:'10', title:'Seminar Công nghệ mới', subtitle:'Phòng 301', time:'09:00', endTime:'11:00', date:yesterdayStr, type:'seminar' },
    { id:'11', title:'Chấm bài thi cuối kỳ', subtitle:'Văn phòng giảng viên', time:'14:00', endTime:'17:00', date:yesterdayStr, type:'grading' },
    { id:'12', title:'Lịch vào trực lớp IT47.8F7', subtitle:'Môn học chuyên ngành', time:'07:30', endTime:'09:00', date:'2025-01-15', type:'class' },
    { id:'13', title:'Hội nghị khoa học sinh viên', subtitle:'Hội trường A', time:'08:30', endTime:'14:00', date:'2025-01-20', type:'conference' },
    { id:'14', title:'Bảo vệ đồ án tốt nghiệp', subtitle:'Phòng 205', time:'13:00', endTime:'17:30', date:'2025-01-25', type:'defense' },
    { id:'15', title:'Tổng kết học kỳ', subtitle:'Phòng họp khoa', time:'15:00', endTime:'18:00', date:'2025-01-30', type:'summary' },
  ];
}

const FilterDay = () => {
  // Tạo dữ liệu 1 lần khi mount, không tái tạo ở mỗi render
  const mockEvents = React.useMemo(() => createMockEvents(), []);

  // GỌI HOOK SAU KHI mockEvents sẵn sàng
  const vm = useFilterDay(mockEvents);

  return <FilterDayView {...vm} />;
};

export default FilterDay;
