import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  SafeAreaView,
  TextInput,
  Image,
  Platform,
  FlatList,
} from 'react-native';
import Header from '../../../components/Header/Header';
import styles from './style';
import R from '../../../assets/R';
import * as SCREENNAME from '../../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
const ListStudentView = props => {
  const {searchText, onSearchChange, dataListStudent, statusStats} = props;
  const navigate = useNavigation();
  const renderSearchBox = () => {
    return (
      <View style={styles.containerSearchBox}>
        <View style={styles.boxIconSearch}>
          <Image
            source={R.images.icSearchHeader}
            maxWidth={Platform.OS === 'ios' ? 16 : 20}
            maxHeight={Platform.OS === 'ios' ? 16 : 20}
            resizeMode="contain"
            tintColor={R.colors.gray}
          />
        </View>
        <TextInput
          placeholder="Tìm kiếm"
          value={searchText}
          onChangeText={onSearchChange}
          placeholderTextColor={R.colors.gray}
          color={R.colors.black}
          style={styles.inputSearch}
        />
      </View>
    );
  };
  const renderListStatus = () => {
    return (
      <View style={styles.statusContainer}>
        {statusStats.map((stat, index) => (
          <View
            key={index}
            style={[styles.statusCard, {borderLeftColor: stat.color}]}>
            <View style={[styles.statusDot, {backgroundColor: stat.color}]} />
            <Text style={[styles.statusText, {color: stat.color}]}>
              {stat.status}
            </Text>
            <Text style={[styles.statusCount, {color: stat.color}]}>
              ({stat.count})
            </Text>
          </View>
        ))}
      </View>
    );
  };

  const renderStudentItem = ({item, onPress}) => {
    const isLeftIcon = item.gender === 'Nam';
    const genderIcon =
      item.gender === 'Nam' ? R.images.icMale : R.images.icFemale;

    const statusColor = getStatusColor(item.status);

    return (
      <TouchableOpacity
        style={styles.studentCard}
        onPress={() => {
          navigate.navigate(SCREENNAME.DETAILSTUDENT);
        }}>
        <View style={styles.studentCardContent}>
          <View style={styles.studentInfo}>
            <View style={styles.leftSection}>
              <Text style={styles.studentName}>{item.name}</Text>
              {isLeftIcon && (
                <Image
                  source={genderIcon}
                  style={styles.genderIcon}
                  resizeMode="contain"
                />
              )}
              {!isLeftIcon && (
                <Image
                  source={genderIcon}
                  style={styles.genderIcon}
                  resizeMode="contain"
                />
              )}
            </View>
            <View style={styles.rightSection}>
              <Text style={styles.studentName}>MSV: {item.code_student}</Text>
              <View
                style={[
                  styles.statusIndicator,
                  {backgroundColor: statusColor},
                ]}>
                <Text style={styles.statusIndicatorText}></Text>
              </View>
            </View>
          </View>
        </View>
        <View style={styles.sizedBox}></View>
        <View style={styles.studentCardContent}>
          <View style={styles.studentInfo}>
            {/*Tên sinh viên*/}
            <View style={styles.leftSection}>
              <Text
                style={[
                  styles.studentName,
                  {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                ]}>
                Ngày sinh: {item.date_student}
              </Text>
            </View>
            <View style={styles.rightSection}>
              <Text
                style={[
                  styles.studentName,
                  {fontFamily: R.fonts.fontRegular, fontWeight: '400'},
                ]}>
                SĐT: {item.tele_phone}
              </Text>
            </View>
          </View>
        </View>
      </TouchableOpacity>
    );
  };

  const getStatusColor = status => {
    const statusColors = {
      'Đang học': '#4CAF50',
      'Cảnh cáo': '#FF9800',
      'Thôi học': '#F44336',
    };
    return statusColors[status] || '#9E9E9E';
  };

  const renderListStudent = () => {
    return (
      <FlatList
        data={dataListStudent || []}
        renderItem={renderStudentItem}
        vertical
        keyExtractor={(item, index) => `${index}`}
        showsVerticalScrollIndicator={false}
        containerStyle={styles.containerList}
      />
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderSearchBox()}
        {renderListStatus()}
        {renderListStudent()}
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Danh sách sinh viên lớp ATTT2024.1'} isBack />
      {renderBody()}
    </View>
  );
};

export default ListStudentView;
