import React from 'react';
import {
  Text,
  View,
  FlatList,
  ScrollView,
  TouchableOpacity,
  Image,
} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import TextField from '../../../components/Input/TextField';
import R from '../../../assets/R';
import TextMulti from '../../../components/Input/TextMulti';
import RadioGroup from '../../../components/RadioButton/RadioGroup';
import Button from '../../../components/Button';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
const NotificationDetailView = props => {
  const {
    showWarning,
    title,
    onTitleChange,
    options,
    selectedValue,
    onValueChange,
    disabled,
    size,
    color,
    direction,
    dataList,
    items,
    options2,
    selectedValue2,
    onValueChange2,
  } = props;

  const renderItem = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
          />
        </TouchableOpacity>
        <Text style={styles.text}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  return (
    <View style={styles.safeArea}>
      <Header isBack title={'Tạo mới thông báo'} />
      <ScrollView contentContainerStyle={{paddingBottom: 20}}>
        <View style={styles.container}>
          <TextField
            containerMarginTop={15}
            title="Tiêu đề thông báo"
            value={title}
            onChangeText={onTitleChange}
            placeholder="HS"
            backgroundColor={R.colors.white}
            color={R.colors.white}
            fontSize={R.sizes.sm}
            onFocus={() => {}}
            fontSizeTitle={R.sizes.sm}
            containerMarginBottom={15}
            required
          />

          <TextField
            title="Mã CBGV"
            value={title}
            onChangeText={onTitleChange}
            backgroundColor={R.colors.grayBorderInputTextHeader}
            color={R.colors.white}
            fontSize={R.sizes.sm}
            onFocus={() => {}}
            fontSizeTitle={R.sizes.sm}
            required
            containerMarginBottom={15}
            editable={false}
          />
          <TextMulti
            title="Nội dung thông báo"
            fontFamily={R.fonts.fontRegular}
            titleFontSize={R.sizes.sm}
            value={title}
            onChangeText={onTitleChange}
            color={R.colors.white}
            fontSize={R.sizes.sm}
            onFocus={() => {}}
            fontSizeTitle={R.sizes.sm}
            fontSizePlaceHolder={R.sizes.sm}
            required
            containerMarginBottom={15}
          />

          <RadioGroup
            options={options}
            selectedValue={selectedValue}
            onValueChange={onValueChange}
            disabled={false}
            size={20}
            backgroundBoxColor={R.colors.blue}
            borderBoxColor={R.colors.black}
            direction={'row'}
            marginBtnAndLabel={10}
            // justifyContent={'space-between'}
            containerMarginRight={39}
            containerMarginBottom={15}
            editable={true}
          />
          <Text style={[styles.text, {marginBottom: 5}]}>
            Chọn những sinh viên nhận thông báo{' '}
            <Text style={{color: R.colors.red}}>*</Text>
          </Text>
          <View style={styles.containerDropdown}>
            <Dropdown
              height={35}
              items={items}
              placeholder="Chọn tùy chọn"
              onSelect={item => console.log('Bạn đã chọn:', item)}
            />
          </View>
          <Text style={[styles.text, {marginBottom: 5}]}>
            Danh sách đã chọn :
          </Text>
          <View style={styles.flatListSelect}>
            {dataList.map((items, index) => (
              <View
                style={styles.flatListSelect}
                key={items.id?.toString() || index}>
                {renderItem({item: items, onPress: () => {}})}
              </View>
            ))}
          </View>
          <View style={styles.sizedBox}></View>

          <RadioGroup
            options={options2}
            selectedValue={selectedValue2}
            onValueChange={onValueChange2}
            disabled={false}
            size={20}
            backgroundBoxColor={R.colors.blue}
            borderBoxColor={R.colors.black}
            direction={'row'}
            marginBtnAndLabel={10}
            // justifyContent={'space-between'}
            containerMarginRight={39}
            containerMarginBottom={15}
            editable={true}
          />

          <View style={styles.containerBtn}>
            <View style={styles.containerInput}>
              <TextField
                title="Ngày gửi"
                value={title}
                onChangeText={onTitleChange}
                color={R.colors.white}
                fontSize={R.sizes.sm}
                onFocus={() => {}}
                fontSizeTitle={R.sizes.sm}
                containerMarginBottom={15}
              />
            </View>
            <View style={{flex: 1}}></View>
            <View style={styles.containerInput}>
              <TextField
                title="Thời gian gửi"
                value={title}
                onChangeText={onTitleChange}
                color={R.colors.white}
                fontSize={R.sizes.sm}
                onFocus={() => {}}
                fontSizeTitle={R.sizes.sm}
                containerMarginBottom={15}
              />
            </View>
          </View>
          <Text style={[styles.txtSubtitle]}>Tài liệu đính kèm</Text>
          <View style={{marginBottom: 15}}>
            <Button
              title="Mẫu văn bản.PDF"
              onPress={() => {}}
              backgroundColor={R.colors.blue1}
              fontSize={R.sizes.sm}
              editable={false}
              height={25}
              width={176}
              borderRadius={10}
              textColor={R.colors.blue}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
              icon={R.images.icCancel}
              iconStyle={{
                width: 15,
                height: 15,
              }}
              containerStyle={{
                alignSelf: 'flex-start',
              }}
            />
          </View>
          <View style={styles.card}>
            <Image
              source={R.images.icDocument}
              resizeMode="contain"
              style={{width: 30, height: 30}}
            />
            <Text style={styles.txtCard}>Mẫu văn bản.PDF</Text>
          </View>
          <View style={{marginVertical: 15}}>
            <Button
              title="Tạo thông báo"
              onPress={() => {}}
              backgroundColor={R.colors.blue}
              fontSize={R.sizes.sm}
              editable={false}
              height={30}
              borderRadius={10}
              textColor={R.colors.white}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
            />
          </View>
        </View>
      </ScrollView>
    </View>
  );
};

export default NotificationDetailView;
