import {StyleSheet, Text, View} from 'react-native';
import R from '../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  card: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 5,
    marginTop: 10,
    marginBottom: 10,
    marginHorizontal: 15,
    alignItems: 'center',
    justifyContent: 'center',

    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  btnCard: {
    borderRadius: 10,
    borderWidth: 1,
    padding: 5,
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  container_tab_view: {
    marginTop:10
  },
  item_tab_view: {
    backgroundColor: R.colors.gray,
    marginHorizontal: 5,
    borderRadius: 10,
    width: 107,
    justifyContent: 'center',
    alignItems: 'center',
  },
  active_tab_view: {
    backgroundColor: R.colors.blue,
  },
  text_tab_view: {
    color: R.colors.white,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    fontSize: R.fontsize.fontSizeContent,
  },
  text: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  searchBox: {
    flex: 1,
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 20,
    alignItems: 'center',
    justifyContent: 'flex-start',
    paddingLeft: 15,
    flexDirection: 'row',
    height: 35,
  },
  box_3: {
    flexDirection: 'row',
    marginHorizontal: 15,
    marginBottom:10,
    alignItems: 'center',
  },
  containerCard: {
    backgroundColor: R.colors.white,
    borderBottomLeftRadius: 15,
    paddingBottom: 10,
    borderBottomRightRadius: 15,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  subText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  listItemContainer: {
    marginHorizontal: 15,
    marginBottom:10
  },
  statusHeader: {
    borderTopLeftRadius: 15,
    borderTopRightRadius: 15,
  },
  statusText: {
    marginHorizontal: 15,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.white,
  },
  cardContent: {
    paddingHorizontal: 15,
    paddingTop: 10,
  },
  rowSpaceBetween: {
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  actionButtonsContainer: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
    marginTop: 10,
  },
  buttonContainerStyle: {
    marginRight: 10,
    borderRadius: 20,
  },
  searchIcon: {
    width: 20,
    height: 20,
  },
  searchInputContainer: {
    flex: 1,
    padding: 0,
    margin: 0,
    height: 35,
  },
  searchInput: {
    height: 35,
    padding: 0,
    marginRight: 15,
  },
  filterSpacer: {
    flex: 0.1,
  },
  dropdownContainer: {
    flex: 1,
  },
  listContainer: {
    marginBottom: 15,
    flex: 1,
  },
});

export default styles;
