import React from 'react';
import {
  Modal,
  View,
  Text,
} from 'react-native';
import styles from './style';
import R from '../../../../assets/R';
import TextField from '../../../../components/Input/TextField';
import Button from '../../../../components/Button';
import TextMulti from '../../../../components/Input/TextMulti';

const ModalRequestEditReportView = props => {
  const {
    visible,
    onClose,
    onSubmit,
    reportDeadline,
    setReportDeadline,
  } = props;

  return (
    <Modal
      visible={visible}
      transparent={true}
      animationType="slide"
      onRequestClose={onClose}>
      <View style={styles.modalOverlay}>
        <View style={styles.modalContainer}>
          <Text style={styles.modalTitle}>Yêu cầu chỉnh sửa báo cáo</Text>
          <TextMulti
            title={'Góp ý báo cáo'}
            required={true}
            value={reportDeadline}
            onChangeText={setReportDeadline}
          />
          <TextField
            title={'Hạn sửa báo cáo'}
            required={true}
            value={reportDeadline}
            onChangeText={setReportDeadline}
          />
          <View style={styles.containerButton}>
            <Button
              title={'Huỷ'}
              onPress={onClose}
              backgroundColor={R.colors.orange}
              textColor={R.colors.white}
              fontSize={R.fontsize.fontSizeContent}
              height={30}
              width={100}
              marginRight={10}
              containerStyle={styles.buttonContainerStyle}
            />
            <Button
              title={'Yêu cầu báo cáo'}
              onPress={onSubmit}
              backgroundColor={R.colors.blue}
              textColor={R.colors.white}
              fontSize={R.fontsize.fontSizeContent}
              height={30}
              width={130}
              containerStyle={styles.buttonContainerStyle}
            />
          </View>
        </View>
      </View>
    </Modal>
  );
};

export default ModalRequestEditReportView;
